void serialWriteChar(char c)
{
	volatile unsigned short *const write = (volatile unsigned short*) 0x20000002;
	volatile unsigned short *const status = (volatile unsigned short*) 0x20000004;

	while( (*status & 0x40) == 0 )
		;
	*write = c;
}

void serialWriteString(char* str)
{
	char c;
	while(1)
	{
		c=*str;
		if(c==0)break;
		serialWriteChar((unsigned short)c);
		str++;		
	}
}

void serialWriteNL()
{
	serialWriteChar('\r');
	serialWriteChar('\n');
}

void serialWriteDecimal(long n)
{
	char out[11];
	int pos;
	out[10]='\0';
	pos=9;
	if(n==0)
	{
		serialWriteChar('0');
		return;
	}
	if(n<0)
	{
		serialWriteChar('-');
		n=-n;
	}
	while(n!=0)
	{
		out[pos--]='0'+((char)(n%10));
		n/=10;
	}
	serialWriteString(&out[pos+1]);
}

void serialWriteHex(long n)
{
	char out[9];
	int pos;
	short z;
	out[8]='\0';
	pos=8;
	while(pos-->0)
	{
		z=n&0xF;
		out[pos]=z<10 ? z+'0' : z-10+'A';
		n>>=4;
	}
	serialWriteString(out);
}
