`include "malwa_defines.v"

module	malwa_decode(
	input clk,
	input reset,
	input stall,
	input clear,

	input irq,

	input [31:0] instr,

	input writeregenduring,
	input [`REGNUM_WIDTH] writeregnumduring,

	input writeregenMduring,
	input writeregen,
	input [`REGNUM_WIDTH] writeregnum,
	input [31:0] writeregdata,

	input writeregenM,
	input [`REGNUM_WIDTH] writeregnumM,
	input [31:0] writeregdataM,
	
	output stallreq,

	output reg [31:0] instrE,
	output reg [`CONTROL_WIDTH] controlE,
	output reg [31:0] rsE,
	output reg [31:0] rtE,
	
	output [31:0] branchoutE,
	
	output [31:0] nextpc,
	output clearpipelineF
);
	
	wire [13:0] controls;
	wire [4:0] alucontrol;
	wire [2:0] branchtype;
	wire [4:0] destreg;
	malwa_decoder d(
		.instr(instr),
 		.controls(controls),
		.alucontrol(alucontrol),
		.branchtype(branchtype),
		.destreg(destreg)
	);
	wire [`CONTROL_WIDTH] control={controls, alucontrol, branchtype, destreg};
	
	reg [31:0] rf[31:1];
	
	wire [31:0] rsFF;//=instr[25:21]==5'b0 ? 32'b0 : instr[25:21]==writeregnum && writeregen ? writeregdata : instr[25:21]==writeregnumM && writeregenM ? writeregdataM : rf[instr[25:21]];
	malwa_ff ff_for_rs(
		.regnum(instr[25:21]),
		.writereg1(writeregnum),
		.writereg2(writeregnumM),
		.writeregen1(writeregen),
		.writeregen2(writeregenM),
		.regdata(rf[instr[25:21]]),
		.writeregdata1(writeregdata),
		.writeregdata2(writeregdataM),
		.out(rsFF)
	);
	
	wire [31:0] rtFF;//=instr[20:16]==5'b0 ? 32'b0 : instr[20:16]==writeregnum && writeregen ? writeregdata : instr[20:16]==writeregnumM && writeregenM ? writeregdataM : rf[instr[20:16]];
	malwa_ff ff_for_rt(
		.regnum(instr[20:16]),
		.writereg1(writeregnum),
		.writereg2(writeregnumM),
		.writeregen1(writeregen),
		.writeregen2(writeregenM),
		.regdata(rf[instr[20:16]]),
		.writeregdata1(writeregdata),
		.writeregdata2(writeregdataM),
		.out(rtFF)
	);
	
	assign stallreq=
	(
		writeregenduring && writeregnumduring!=5'd0 &&
		(
			(instr[25:21]==writeregnumduring && (control[`CONTROL_BRANCH] || control[`CONTROL_REGJUMP]))
		||
			(instr[20:16]==writeregnumduring
				&& control[`CONTROL_BRANCH]
				&& (control[`CONTROL_BRANCHTYPE]==`BR_EQ || control[`CONTROL_BRANCHTYPE]==`BR_NE)
			)
		)
	)
	||
	(
		writeregenMduring && writeregnum!=5'd0 &&
		(
			(instr[25:21]==writeregnum && (control[`CONTROL_BRANCH] || control[`CONTROL_REGJUMP]))
		||
			(instr[20:16]==writeregnum
				&& control[`CONTROL_BRANCH]
				&& (control[`CONTROL_BRANCHTYPE]==`BR_EQ || control[`CONTROL_BRANCHTYPE]==`BR_NE)
			)
		)
	)
	;

	always @(posedge clk)
	begin
		if(writeregnumM!=5'b0 && writeregenM)
			rf[writeregnumM] <= writeregdataM;

		if(writeregnum!=5'b0 && writeregen)
			rf[writeregnum] <= writeregdata;
		
		if( reset )
		begin
			instrE <= 0;
			controlE <= 0;
			rsE <= 0;
			rtE <= 0;
			
			rf[29] <= 32'h0077_FFFC;
		end
		else if( stall )
		begin
			//Stall instrE
			//Stall controlE
			//Stall rsE
			//Stall rtE
		end
		else if( clear )
		begin
			instrE <= 0;
			controlE <= 0;
			rsE <= 0;
			rtE <= 0;
		end
		else
		begin
			instrE <= instr;
			controlE <= control;
			rsE <= rsFF;
			rtE <= rtFF;
		end
	end
	
	malwa_branch b(
		.clk(clk),
		.reset(reset),
		.stall(stall || clear), /* i_stall || de_stall || ex_stall || d_stall */

		.irq(irq),
		
		.instr(instr),
		.control(control),
		.rs(rsFF),
		.rt(rtFF),
		
		.branchout(branchoutE),
		
		.nextpc(nextpc),
		.clearpipelineF(clearpipelineF)		
	);
	
endmodule