`define WIDTH_TAG	10:0
`define WIDTH_VALID	3:0

module cache_datastore(
	input			clk,
	
	input [3:0]		i_match,
	input [1:0]		i_set,
	input [7:0]		i_index,
	input [1:0]		i_line,
	input			i_write,
	input [31:0]	i_writedata,
	output [31:0]	i_data,
	
	input [3:0]		d_match,
	input [1:0]		d_set,
	input [7:0]		d_index,
	input [1:0]		d_line,
	input [1:0]		d_address,
	input			d_write,
	input			d_dowrite,
	input			d_mem16,
	input			d_mem8,
	input			idle,
	input [31:0]	d_writedata,
	input [31:0]	d_writedata_cache,
	output [31:0]	d_readdata_word,
	output [31:0]	d_readdata
);
	assign d_readdata=
				 d_mem16?	{16'b0,d_address[1] ? 	d_readdata_word[15:0] : d_readdata_word[31:16]}
				:d_mem8	?	{24'b0,
							 d_address[1:0]==2'd0 ?	d_readdata_word[31:24]
							:d_address[1:0]==2'd1 ?	d_readdata_word[23:16]
							:d_address[1:0]==2'd2 ?	d_readdata_word[15:8]
							:d_address[1:0]==2'd3 ?	d_readdata_word[7:0]
							:					8'hXX
							}
				:			d_readdata_word;
	
	wire [31:0]d_writedata_word=
				d_dowrite&&idle ?
					 d_mem16?	 d_address[1] ?			{d_readdata_word[31:16],d_writedata[15:0]}
								:						{d_writedata[15:0],d_readdata_word[15:0]}
					:d_mem8	?	
							 	 d_address[1:0]==2'd0 ?	{d_writedata[7:0],d_readdata_word[23:0]}
								:d_address[1:0]==2'd1 ?	{d_readdata_word[31:24],d_writedata[7:0],d_readdata_word[15:0]}
								:d_address[1:0]==2'd2 ?	{d_readdata_word[31:16],d_writedata[7:0],d_readdata_word[7:0]}
								:d_address[1:0]==2'd3 ?	{d_readdata_word[31:8],d_writedata[7:0]}
								:						32'hXXXX_XXXX
					:									d_writedata
				:
					d_writedata_cache
				;
	
	assign i_data=i_set==2'd0 ?	i_data_set[31:0]
				 :i_set==2'd1 ?	i_data_set[63:32]
				 :i_set==2'd2 ?	i_data_set[95:64]
				 :i_set==2'd3 ?	i_data_set[127:96]
				 :				32'hXXXX_XXXX;

	assign d_readdata_word=	 d_set==2'd0 ?	d_data_set[31:0]
							:d_set==2'd1 ?	d_data_set[63:32]
							:d_set==2'd2 ?	d_data_set[95:64]
							:d_set==2'd3 ?	d_data_set[127:96]
							:				32'hXXXX_XXXX;

	wire [3:0] i_write_munged={4{i_write}}&i_match;
	wire [3:0] d_write_munged={4{d_write}}&d_match;
	
	wire [127:0] i_data_set;
	wire [127:0] d_data_set;

	cache_data cd[3:0](
		.address_a({i_index,i_line}),
		.address_b({d_index,d_line}),
		.clock_a(clk),
		.clock_b(clk),
		.data_a(i_writedata),
		.data_b(d_writedata_word),
		.wren_a(i_write_munged),
		.wren_b(d_write_munged),
		.q_a(i_data_set),
		.q_b(d_data_set)
	);

endmodule