package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class Type
{
static public final int typeVar    = 0;
static public final int boolType   = 1;
static public final int intType    = 2;
static public final int stringType = 3;
static public final int tupleType  = 4;
static public final int listType   = 5;
static public final int funType    = 6;

int flavour;      // sort of thing I am.
String name;
Type t1;
Type t2;
int serNum;       // used just when debugging

static int count = 1;

public Type(int flavour)
{
    this.flavour = flavour;
    name = null;
    this.t1 = this.t2 = null;
    if (flavour == typeVar) serNum = count++;
}

public Type(int flavour, Type t1, Type t2)
{
    this.flavour = flavour;
    name = null;
    this.t1 = t1;
    this.t2 = t2;
    if (flavour == typeVar) serNum = count++;
}

static Type xintType = new Type(intType);

static Type xboolType = new Type(boolType);

static Type fn(Type u, Type v)
{
    return new Type(funType, u, v);
}

static Type sType()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    return fn(
        fn(a, fn(b, c)),
        fn(fn(a, b), fn(a, c)));
    // (a -> (b -> c)) -> ((a -> b) -> (a -> c))
}

static Type kType()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    return fn(a, fn(b, a));   // 'a -> ('b -> 'a)
}

static Type iType()
{
    Type a = new Type(typeVar);
    return fn(a, a);   // 'a -> 'a
}

static Type yType()
{
    Type a = new Type(typeVar);
    return fn(fn(a, a), a);   // ('a -> 'a) -> 'a
}

static Type bType()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    return fn(
        fn(a, b),
        fn(fn(c, a), fn(c, b)));
    // (a -> b) -> ((c -> a) -> (c -> b))
}

static Type cType()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    return fn(
        fn(a, fn(b, c)),
        fn(b, fn(a, c)));
    // (a -> (b -> c)) -> (b -> (a -> c))
}

static Type b1Type()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    Type d = new Type(typeVar);
    return fn(
        fn(a, fn(b, c)),
        fn(a, fn(fn(d, b), fn(d, c))));
    // (a -> (b -> c)) -> (a -> ((d -> b) -> (d -> c)))
}

static Type c1Type()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    Type d = new Type(typeVar);
    return fn(
        fn(a, fn(b, c)),
        fn(fn(d, a), fn(b, fn(d, c))));
    // (a -> (b -> c)) -> ((d -> a) -> (b -> (d -> c)))
}

static Type s1Type()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type c = new Type(typeVar);
    Type d = new Type(typeVar);
    return fn(
        fn(a, fn(b, c)),
        fn(fn(d, a), 
           fn(fn(d, b), fn(d, c))));
    // (a -> (b -> c)) -> ((d -> a) -> ((d -> b) -> (d -> c)))
}

static Type pType()
{
    Type a = new Type(typeVar);
    return fn(a, fn(new Type(listType, a, null),
                    new Type(listType, a, null)));
}

static Type uType()
{
    Type a = new Type(typeVar);
    Type b = new Type(typeVar);
    Type al = new Type(listType, a, null);
    return fn(fn(a, b),
              fn(fn(a, fn(al, b)),
                 fn(al, b)));
}

static Type unaryArithType()
{
    return fn(xintType, xintType);
}

static Type binaryArithType()
{
    return fn(xintType, fn(xintType, xintType));
}

static Type boolopType()
{
    return fn(xboolType, fn(xboolType, xboolType));
}

static Type compareArithType()
{
    return fn(xintType, fn(xintType, xboolType));
}

static Type compareType()
{
    return fn(new Type(typeVar), fn(new Type(typeVar), xboolType));
}

static Type ifType()
{
    Type a = new Type(typeVar);
    return fn(xboolType, fn(a, fn(a, a)));
}

static int nameCount = 0;

String typeName()
{
    int n = nameCount++;
    int l = n % 26;
    n = n / 26;
    String s = String.valueOf((char)('a' + l));
    if (n != 0) s = s + String.valueOf(n);
// @@
//  s = s + serNum;
// @@
    return s;
}

void clearNames()
{
    name = null;
// The next test should be unnecessary but is here as a fail-stop
    if (flavour == intType ||
        flavour == boolType ||
        flavour == stringType) return;
    if (t1 != null && t1 != this) t1.clearNames();
    if (t2 != null && t2 != this) t2.clearNames();
}

void cleart2()
{
    if (t1 != null) t1.cleart2();
    if (flavour == typeVar) t2 = null;
    else if (t2 != null) t2.cleart2();
}

public void print()
{
    clearNames();
    nameCount = 0;
    internalPrint(true);
}

void internalPrint(boolean topLevel)
{
    switch (flavour)
    {
case typeVar:
        Type t = this;
        while (t.flavour == typeVar &&
               t.t1 != null) t = t.t1;
        if (t.flavour != typeVar)
        {   t.internalPrint(topLevel);
            return;
        }
        if (t.name == null) t.name = t.typeName();
        Graph.text("'" + t.name);
        return;
case boolType:
        Graph.text("boolean");
        return;
case intType:
        Graph.text("int");
        return;
case stringType:
        Graph.text("string");
        return;
case tupleType:
        if (!topLevel) Graph.text("(");
        t1.internalPrint(false);
	Graph.text(" * ");
	t2.internalPrint(false);
        if (!topLevel) Graph.text(")");
        return;
case listType:
        if (!topLevel) Graph.text("(");
        t1.internalPrint(false);
	Graph.text(" list");
        if (!topLevel) Graph.text(")");
        return;
case funType:
        if (!topLevel) Graph.text("(");
        t1.internalPrint(false);
        Graph.text(" -> ");
	t2.internalPrint(false);
        if (!topLevel) Graph.text(")");
        return;
    }
}

public void debugPrint()
{
    switch (flavour)
    {
case typeVar:
        Graph.text("v"+serNum);
        if (t1 != null)
        {   Graph.text("{");
            t1.debugPrint();
            Graph.text("}");
        }
        return;
case boolType:
        Graph.text("boolean");
        return;
case intType:
        Graph.text("int");
        return;
case stringType:
        Graph.text("string");
        return;
case tupleType:
        Graph.text("(");
        t1.debugPrint();
	Graph.text(") * (");
	t2.debugPrint();
        Graph.text(")");
        return;
case listType:
        Graph.text("(");
        t1.debugPrint();
	Graph.text(") list");
        return;
case funType:
        Graph.text("(");
        t1.debugPrint();
	Graph.text(")->(");
	t2.debugPrint();
        Graph.text(")");
        return;
    }
}

Type deref()
{
    Type t = this;
    while (t.flavour == typeVar &&
           t.t1 != null) t = t.t1;
    return t;
}

void occursCheck(Type v) throws NoType
{
    switch (flavour)
    {
case typeVar:
        if (this == v) throw new NoType();
        if (t1 != null) t1.occursCheck(v);
        return;
case boolType:
case intType:
case stringType:
        return;
case tupleType:
case funType:
        t1.occursCheck(v);
        t2.occursCheck(v);
        return;
case listType:
        t1.occursCheck(v);
        return;
    }
}

void unifyWith(Type tb) throws NoType
{
    Type ta = deref();
    tb = tb.deref();
    if (Graph.debugFlag)
    {   Graph.text("unify "); ta.debugPrint();
        Graph.text(" with "); tb.debugPrint(); Graph.newline();
    }
    if (ta.flavour != tb.flavour)
    {   if (ta.flavour == typeVar)
        {   tb.occursCheck(ta);
            if (Graph.debugFlag)
            {   Graph.text("v" + ta.serNum + " ==> ");
                tb.debugPrint();
                Graph.newline();
            }
            ta.t1 = tb;
            if (Graph.debugFlag) Graph.text("unified\n");
            return;
        } 
        else if (tb.flavour == typeVar)
        {   ta.occursCheck(tb);
            if (Graph.debugFlag)
            {   Graph.text("v" + tb.serNum + " ==> ");
                ta.debugPrint();
                Graph.newline();
            }
            tb.t1 = ta;
            if (Graph.debugFlag) Graph.text("unified\n");
            return;
        }
        else throw new NoType();
    }
    switch (ta.flavour)
    {
case typeVar:
// Both have been dereferenced here so both should be uninstantiated.
        if (ta != tb)
        {   if (Graph.debugFlag)
            {   Graph.text("v" + ta.serNum + " ==> ");
                tb.debugPrint();
                Graph.newline();
            }
            ta.t1 = tb;
        }
        if (Graph.debugFlag) Graph.text("unified\n");
        return;
case boolType:
case intType:
case stringType:
        if (Graph.debugFlag) Graph.text("unified\n");
        return;
case tupleType:
case funType:
        ta.t1.unifyWith(tb.t1);
        ta.t2.unifyWith(tb.t2);
        if (Graph.debugFlag) Graph.text("unified\n");
        return;
case listType:
        ta.t1.unifyWith(tb.t1);
        if (Graph.debugFlag) Graph.text("unified\n");
        return;
    }
}

public Type copy()
{
    cleart2();
    Type r = internalCopy();
    cleart2();
    return r;
}

Type internalCopy()
{
    switch (flavour)
    {
case typeVar:
        Type t = deref();
        if (t.flavour != typeVar) return t.internalCopy();
        if (t.t2 == null) t.t2 = new Type(typeVar);
        return t.t2;
//case boolType:
//case intType:
//case stringType:
default:
        return this;
case tupleType:
case funType:
        return new Type(flavour, t1.internalCopy(), t2.internalCopy());
case listType:
        return new Type(flavour, t1.internalCopy(), null);
    }
}

}


