package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

// (if a b c) should evaluate a. If the result is true then the result
// is b, otherwise it is c. As a way of achieving this effect what I
// do is to treat "if" as a function of one argument such that
//    if true   =>   K
//    if false  =>   (K I)
// and then subsequent processing of the K or (K I) finishes the
// job for me.
 
public class IfCombinator extends Combinator
{

public IfCombinator()
{
    name = "IF";
}

boolean makeHeadNormal() throws TooManySteps
{
    if (trail == null) return false;
    Application trail1 = (Application)trail.function;
    Graph a = Graph.makeHeadNormal(trail.argument);
    trail.argument = a;
    if (!(a instanceof Gboolean)) return false;
    trail.function = current;
    trail = trail1;
    current = ((Gboolean)a).value ? K : KI;
    return true;
}

}


