package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public abstract class Combinator extends Graph
{

String name = "UNKNOWN"; 

public void print() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    text(name);
}

public void reduceAndPrint() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    text(name);
}


boolean eqC(String name)
{
    return (name.equals(this.name));
}
    
public Type typeCheck(Environment e) throws NoType
{
    String xname = name.toLowerCase();
    int len = xname.length();
    char last = xname.charAt(len-1);
    if (last == '\'')
    {   xname = xname.substring(0, len-1) + "1";
    }
    xname = "@" + xname;
    Type r = (Type)types.get(xname);
    if (Graph.debugFlag)
    {   Graph.text("get type for " + name + " (" + xname + ")\n");
    }
    if (r == null) throw new NoType();
    if (Graph.debugFlag)
    {   Graph.text("before copy: "); 
        r.debugPrint(); 
        Graph.newline();
    }
    r = r.copy();
// Graph.text("after copy: "); r.debugPrint(); Graph.newline(); @@@
    return r;
}

}


