package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class BasicFun extends Fun
{

public Args f;
public Graph b;
Type type;

public BasicFun(Args f, Graph b)
{
    this.f = f;
    this.b = b;
    type = null;
}

public void print() throws TooManySteps
{
    Graph.text("FUN ");
    f.print();
    Graph.text(" = ");
    b.print();
}

public void instate()
{
    Args f1 = f;
    Graph b1 = b;
    while (f1.name == null)
    {   Pattern arg = f1.a;
        f1 = f1.f;
	if (arg instanceof NamePattern)
	{   b1 = b1.abs(((NamePattern)arg).name);
	}
	else
	{   Graph.text("Arg spec "); arg.print(64);
	    Graph.text(" too complicated for now");
	    Graph.newline();
	}
    }
    b1 = b1.abs(f1.name);
    b1 = Application.makeY(b1);
    b1 = b1.substitute();
    Graph.text("Combinator form: "); b1.print(500); Graph.newline();
    Graph.values.put(f1.name, b1);
    if (type != null) Graph.types.put(f1.name, type);
    else Graph.types.remove(f1.name);
}

public Environment typeCheckDef(Environment e) throws NoType
{
    Args f1 = f;
    Graph b1 = b;
    while (f1.name == null)
    {   Pattern arg = f1.a;
        f1 = f1.f;
	if (arg instanceof NamePattern)
	{   b1 = b1.abs(((NamePattern)arg).name);
	}
	else
	{   Graph.text("Arg spec "); arg.print(64);
	    Graph.text(" too complicated for now");
	    Graph.newline();
            throw new NoType();
	}
    }
    b1 = b1.abs(f1.name);
    b1 = Application.makeY(b1);
    Type type1 = b1.typeCheck(e);
    type = type1;
    return new Environment(f1.name, type1, null);
}

}



