/* Rosemary Francis
 * 
 * This program generates a testing program for ifs and imm in N_105 assembler
 * It is only designed to be used for alu instructions. 
 * It is assumed that the instructions not being tested work trivially
 */
import java.io.*;
import java.util.*;

public class IfTestGen_imm
{
    public static void main(String [] args)
    {
	try
	{
	    
	if(args.length != 2)
	{
	    System.out.println("Usage : java IfTestGen_imm <prog name> <op>");
	}
		
	String prog_name = args [0];
	String op = args [1];
	    
	String readme = ";This file has been autonatically generated by a program called IfTestGen. \n ;Alter at your own risk! \n";
	    
	BufferedWriter out = new BufferedWriter(new FileWriter(prog_name));
	out.write(readme,0,readme.length());

	write_funtion(out, -1, -5, 1, op);
	write_funtion(out, -5, -1, 2, op);
	write_funtion(out, 1, 5, 3, op);
	write_funtion(out, 5, 1, 4, op);
	write_funtion(out, -3, 6, 5, op);
	write_funtion(out, -8, 2, 6, op);
	write_funtion(out, 9, -5, 7, op);
	write_funtion(out, 5, -9, 8, op);
	write_funtion(out, -3, -3, 9, op);
	write_funtion(out, 3, 3, 10, op);
	write_funtion(out, 0, 0, 11, op);  
	write_funtion(out, -3, 0, 12, op); 
	write_funtion(out, 4, 0, 13, op);
	write_funtion(out, 0, -8, 14, op);
	write_funtion(out, 0, 5, 15, op);

	out.close();

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

    static void write_funtion(BufferedWriter out, int r0, int imm, int reg, String op)
    {
	
	String line;
	String num;
	

	try
	{
		

		//////////////////////////////////////////////////////

		line = "movi r0 ";              
		out.write(line, 0, line.length()); 

		num = Integer.toString(r0);           
		out.write(num, 0, num.length());

		line = " " + op + " r0 ";              
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

	       	line = " ifs cc_nc addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		    
		line = " 0 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());
		
		line = " ifs cc_c addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());
		
		//////////////////////////////////////////////////////

		line = " 1 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_nz addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 2 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_z addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 4 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_pl addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 5 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_mi addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 8 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_lt addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 9 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_ge addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 13 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_gt addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 14 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_le addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////
		
		line = " 19 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_nv addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 20 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_v addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 26 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length()); 

		line = " ifs cc_hi addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		line = " 27 " + op + " r0 ";             
		out.write(line, 0, line.length());

		num = Integer.toString(imm);
		out.write(num, 0, num.length());

		line = " ifs cc_la addi r";              
		out.write(line, 0, line.length());

		num = Integer.toString(reg);           
		out.write(num, 0, num.length());

		//////////////////////////////////////////////////////

		line = " 26 ";             
		out.write(line, 0, line.length());
	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

}






























