//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module onchip_rom_lane0_module (
                                 // inputs:
                                  address,
                                  clk,
                                  reset_n,

                                 // outputs:
                                  q
                               );

  output  [ 15: 0] q;
  input   [  9: 0] address;
  input            clk;
  input            reset_n;

  reg     [ 15: 0] mem_array [1023: 0];
  wire    [ 15: 0] q;
  reg     [  9: 0] read_address;

//exemplar translate_off
`ifdef MODEL_TECH
//////////////// SIMULATION-ONLY CONTENTS
  always @(posedge clk or negedge reset_n)
    begin
      if (reset_n == 0)
          read_address <= 0;
      else if (1)
          read_address <= address;
    end


  // Data read is synchronized through latent_rdaddress.
  assign q = mem_array[read_address];

initial
    $readmemh("onchip_rom_lane0.dat", mem_array);
`endif

//exemplar translate_on
//synthesis read_comments_as_HDL on
//  always @(address)
//    begin
//      if (1)
//          read_address <= address;
//    end
//
//
//  lpm_rom lpm_rom_component
//    (
//      .address (read_address),
//      .inclock (clk),
//      .q (q)
//    );
//
//  defparam lpm_rom_component.lpm_address_control = "REGISTERED",
//           lpm_rom_component.lpm_file = "onchip_rom_lane0.mif",
//           lpm_rom_component.lpm_outdata = "UNREGISTERED",
//           lpm_rom_component.lpm_width = 16,
//           lpm_rom_component.lpm_widthad = 10,
//           lpm_rom_component.suppress_memory_conversion_warnings = "ON";
//
//synthesis read_comments_as_HDL off


endmodule


module onchip_rom (
                    // inputs:
                     address,
                     clk,
                     reset_n,

                    // outputs:
                     readdata
                  );

  output  [ 15: 0] readdata;
  input   [  9: 0] address;
  input            clk;
  input            reset_n;

  wire    [  9: 0] onchip_rom_lane0_address;
  wire    [ 15: 0] q_lane_0;
  wire    [ 15: 0] readdata;
  wire             select_all_chunks;
  assign select_all_chunks = 1;
  assign onchip_rom_lane0_address = address;
  onchip_rom_lane0_module onchip_rom_lane0
    (
      .address (onchip_rom_lane0_address),
      .clk     (clk),
      .q       (q_lane_0),
      .reset_n (reset_n)
    );

  assign readdata = q_lane_0;


endmodule

