# Interface Boards Pin Definitions for the EPXA1 board  (using the Standard Expansion header)
# Andrew West  29/09/2002
# Modified (30 July 2003) by:
#   Phil Wise
#   Gordon Williams 
# Modified August 2004 by:
#   Rosemary Francis
#
#          *********************
#          *  VERSION 0.0002   *
#          *********************

# Please note that these pinouts have NOT been verified on an EPXA1 board yet, so may
# contain errors. 

# Altera-provided instructions how to run a Tcl:
# You can run this script from Quartus by observing the following steps:
# 1. Place this TCL script in your project directory
# 2. Open your project
# 3. Go to the View Menu and Auxilary Windows -> TCL console
# 4. In the TCL console type:
#						source epxa1_pin_assignments.tcl
# 5. The script will assign pins and return an "assignment made" message.
#    It might take about 30 seconds for the script to run.


# Problems...
# 1. Unsure of clock pin (but it works :p) - currently using U1 - CLKA_1/CLK1p

# SET THE VALUE OF top_name HERE TO BE YOUR TOP LEVEL MODULE NAME (e.g. main)
set top_name N_105_system;


#############################################################################################

set cmp_settings_group $top_name
if { ![project cmp_exists $cmp_settings_group] } {
        project create_cmp $top_name
}
project set_active_cmp $top_name

cmp add_assignment $top_name "" "" "DEVICE" "EPXA1F484C1";
cmp add_assignment $top_name "" "" "ENABLE_INIT_DONE_OUTPUT" "ON";



# 16x2 LCD
cmp add_assignment $top_name "" "LCD_RS" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_EN" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_RW" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[0\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[1\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[2\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[3\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[4\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[5\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[6\]" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "LCD_D\[7\]" "IO_STANDARD" "LVTTL";

cmp add_assignment $top_name "" "LCD_RS" "LOCATION" "Pin_AA14";
cmp add_assignment $top_name "" "LCD_EN" "LOCATION" "Pin_AB4";
cmp add_assignment $top_name "" "LCD_RW" "LOCATION" "Pin_AA12";
cmp add_assignment $top_name "" "LCD_D\[0\]" "LOCATION" "Pin_AA10";
cmp add_assignment $top_name "" "LCD_D\[1\]" "LOCATION" "Pin_AA9";
cmp add_assignment $top_name "" "LCD_D\[2\]" "LOCATION" "Pin_AA8";
cmp add_assignment $top_name "" "LCD_D\[3\]" "LOCATION" "Pin_AA7";
cmp add_assignment $top_name "" "LCD_D\[4\]" "LOCATION" "Pin_AA6";
cmp add_assignment $top_name "" "LCD_D\[5\]" "LOCATION" "Pin_AA5";
cmp add_assignment $top_name "" "LCD_D\[6\]" "LOCATION" "Pin_AA4";
cmp add_assignment $top_name "" "LCD_D\[7\]" "LOCATION" "Pin_AA3";

# Other stuff
cmp add_assignment $top_name "" "" "RESERVE_ALL_UNUSED_PINS" "AS INPUT TRI-STATED";

cmp add_assignment $top_name "" "reset_n" "IO_STANDARD" "LVTTL";
cmp add_assignment $top_name "" "reset_n" "LOCATION" "Pin_U18";

# End
