library verilog;
use verilog.vl_types.all;
entity instruction_decode is
    generic(
        c               : integer := 0;
        z               : integer := 1;
        v               : integer := 2;
        n               : integer := 3
    );
    port(
        clk             : in     vl_logic;
        reset           : in     vl_logic;
        advance_pipeline: in     vl_logic;
        ld_st_coming    : out    vl_logic;
        next_instruction: in     vl_logic_vector(15 downto 0);
        condition_flags : in     vl_logic_vector(3 downto 0);
        set_cond_en     : out    vl_logic;
        alu_opcode      : out    vl_logic_vector(3 downto 0);
        imm7            : out    vl_logic_vector(6 downto 0);
        imm11           : out    vl_logic_vector(10 downto 0);
        index_a         : out    vl_logic_vector(3 downto 0);
        index_b         : out    vl_logic_vector(3 downto 0);
        alu_en          : out    vl_logic;
        br_unit_en      : out    vl_logic;
        load_n_store    : out    vl_logic;
        return_en       : out    vl_logic;
        bsr_en          : out    vl_logic
    );
end instruction_decode;
