//megafunction wizard: %Altera SOPC Builder%
//GENERATION: STANDARD
//VERSION: WM1.0


//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module lcd_16207_0_control_slave_arbitrator (
                                              // inputs:
                                               clk,
                                               d2_reset_n,
                                               lcd_16207_0_control_slave_readdata,
                                               uoccl_n105_0_data_master_address_to_slave,
                                               uoccl_n105_0_data_master_byteenable,
                                               uoccl_n105_0_data_master_read,
                                               uoccl_n105_0_data_master_write,
                                               uoccl_n105_0_data_master_writedata,

                                              // outputs:
                                               d1_lcd_16207_0_control_slave_end_xfer,
                                               lcd_16207_0_control_slave_address,
                                               lcd_16207_0_control_slave_begintransfer,
                                               lcd_16207_0_control_slave_read,
                                               lcd_16207_0_control_slave_readdata_from_sa,
                                               lcd_16207_0_control_slave_wait_counter_eq_0,
                                               lcd_16207_0_control_slave_write,
                                               lcd_16207_0_control_slave_writedata,
                                               uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave,
                                               uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave,
                                               uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave
                                            );

  output           d1_lcd_16207_0_control_slave_end_xfer;
  output  [  1: 0] lcd_16207_0_control_slave_address;
  output           lcd_16207_0_control_slave_begintransfer;
  output           lcd_16207_0_control_slave_read;
  output  [  7: 0] lcd_16207_0_control_slave_readdata_from_sa;
  output           lcd_16207_0_control_slave_wait_counter_eq_0;
  output           lcd_16207_0_control_slave_write;
  output  [  7: 0] lcd_16207_0_control_slave_writedata;
  output           uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave;
  output           uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave;
  output           uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave;
  input            clk;
  input            d2_reset_n;
  input   [  7: 0] lcd_16207_0_control_slave_readdata;
  input   [ 15: 0] uoccl_n105_0_data_master_address_to_slave;
  input   [  3: 0] uoccl_n105_0_data_master_byteenable;
  input            uoccl_n105_0_data_master_read;
  input            uoccl_n105_0_data_master_write;
  input   [ 15: 0] uoccl_n105_0_data_master_writedata;

  reg              d1_lcd_16207_0_control_slave_end_xfer;
  reg              d1_reasons_to_wait;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  1: 0] lcd_16207_0_control_slave_address;
  wire             lcd_16207_0_control_slave_begins_xfer;
  wire             lcd_16207_0_control_slave_begintransfer;
  wire    [  5: 0] lcd_16207_0_control_slave_counter_load_value;
  wire             lcd_16207_0_control_slave_end_xfer;
  wire             lcd_16207_0_control_slave_in_a_read_cycle;
  wire             lcd_16207_0_control_slave_in_a_write_cycle;
  wire             lcd_16207_0_control_slave_pretend_byte_enable;
  wire             lcd_16207_0_control_slave_read;
  wire    [  7: 0] lcd_16207_0_control_slave_readdata_from_sa;
  reg     [  5: 0] lcd_16207_0_control_slave_wait_counter;
  wire             lcd_16207_0_control_slave_wait_counter_eq_0;
  wire             lcd_16207_0_control_slave_waits_for_read;
  wire             lcd_16207_0_control_slave_waits_for_write;
  wire             lcd_16207_0_control_slave_write;
  wire    [  7: 0] lcd_16207_0_control_slave_writedata;
  wire             uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave;
  wire             uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave;
  wire             uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave;
  wire             wait_for_lcd_16207_0_control_slave_counter;
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_reasons_to_wait <= 0;
      else if (1)
          d1_reasons_to_wait <= ~lcd_16207_0_control_slave_end_xfer;
    end


  assign lcd_16207_0_control_slave_begins_xfer = ~d1_reasons_to_wait & ((uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave));
  assign uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave = ({uoccl_n105_0_data_master_address_to_slave[15 : 3] , 3'b0} == 16'h8000) & (uoccl_n105_0_data_master_read | uoccl_n105_0_data_master_write);
  //assign lcd_16207_0_control_slave_readdata_from_sa = lcd_16207_0_control_slave_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign lcd_16207_0_control_slave_readdata_from_sa = lcd_16207_0_control_slave_readdata;

  assign uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave = uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave;
  //lcd_16207_0_control_slave_writedata mux, which is an e_mux
  assign lcd_16207_0_control_slave_writedata = uoccl_n105_0_data_master_writedata;

  //master is always granted when requested
  assign uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave = uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave;

  //lcd_16207_0_control_slave_end_xfer assignment, which is an e_assign
  assign lcd_16207_0_control_slave_end_xfer = ~(lcd_16207_0_control_slave_waits_for_read | lcd_16207_0_control_slave_waits_for_write);

  assign lcd_16207_0_control_slave_begintransfer = lcd_16207_0_control_slave_begins_xfer;
  //lcd_16207_0_control_slave_address mux, which is an e_mux
  assign lcd_16207_0_control_slave_address = uoccl_n105_0_data_master_address_to_slave >> 1;

  //lcd_16207_0_control_slave_read assignment, which is an e_mux
  assign lcd_16207_0_control_slave_read = ((uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave & uoccl_n105_0_data_master_read)) & ~lcd_16207_0_control_slave_begins_xfer & (lcd_16207_0_control_slave_wait_counter < 13);

  //lcd_16207_0_control_slave_write assignment, which is an e_mux
  assign lcd_16207_0_control_slave_write = ((uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave & uoccl_n105_0_data_master_write)) & ~lcd_16207_0_control_slave_begins_xfer & (lcd_16207_0_control_slave_wait_counter >= 13) & (lcd_16207_0_control_slave_wait_counter < 26) & lcd_16207_0_control_slave_pretend_byte_enable;

  //d1_lcd_16207_0_control_slave_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_lcd_16207_0_control_slave_end_xfer <= 1;
      else if (1)
          d1_lcd_16207_0_control_slave_end_xfer <= lcd_16207_0_control_slave_end_xfer;
    end


  assign lcd_16207_0_control_slave_waits_for_read = lcd_16207_0_control_slave_in_a_read_cycle & wait_for_lcd_16207_0_control_slave_counter;
  //lcd_16207_0_control_slave_in_a_read_cycle assignment, which is an e_assign
  assign lcd_16207_0_control_slave_in_a_read_cycle = uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave & uoccl_n105_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = lcd_16207_0_control_slave_in_a_read_cycle;

  assign lcd_16207_0_control_slave_waits_for_write = lcd_16207_0_control_slave_in_a_write_cycle & wait_for_lcd_16207_0_control_slave_counter;
  //lcd_16207_0_control_slave_in_a_write_cycle assignment, which is an e_assign
  assign lcd_16207_0_control_slave_in_a_write_cycle = uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave & uoccl_n105_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = lcd_16207_0_control_slave_in_a_write_cycle;

  assign lcd_16207_0_control_slave_wait_counter_eq_0 = lcd_16207_0_control_slave_wait_counter == 0;
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          lcd_16207_0_control_slave_wait_counter <= 0;
      else if (1)
          lcd_16207_0_control_slave_wait_counter <= lcd_16207_0_control_slave_counter_load_value;
    end


  assign lcd_16207_0_control_slave_counter_load_value = ((lcd_16207_0_control_slave_in_a_write_cycle & lcd_16207_0_control_slave_begins_xfer))? 37 :
    ((lcd_16207_0_control_slave_in_a_read_cycle & lcd_16207_0_control_slave_begins_xfer))? 24 :
    (~lcd_16207_0_control_slave_wait_counter_eq_0)? lcd_16207_0_control_slave_wait_counter - 1 :
    0;

  assign wait_for_lcd_16207_0_control_slave_counter = lcd_16207_0_control_slave_begins_xfer | ~lcd_16207_0_control_slave_wait_counter_eq_0;
  //lcd_16207_0_control_slave_pretend_byte_enable mux, which is an e_mux
  assign lcd_16207_0_control_slave_pretend_byte_enable = (uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave)? uoccl_n105_0_data_master_byteenable :
    -1;


  // exemplar attribute lcd_16207_0_control_slave_arbitrator auto_dissolve FALSE

endmodule


module onchip_ram_s1_arbitrator (
                                  // inputs:
                                   clk,
                                   d2_reset_n,
                                   onchip_ram_s1_readdata,
                                   uoccl_n105_0_data_master_address_to_slave,
                                   uoccl_n105_0_data_master_byteenable,
                                   uoccl_n105_0_data_master_read,
                                   uoccl_n105_0_data_master_write,
                                   uoccl_n105_0_data_master_writedata,

                                  // outputs:
                                   d1_onchip_ram_s1_end_xfer,
                                   onchip_ram_s1_address,
                                   onchip_ram_s1_readdata_from_sa,
                                   onchip_ram_s1_reset_n,
                                   onchip_ram_s1_writebyteenable,
                                   onchip_ram_s1_writedata,
                                   uoccl_n105_0_data_master_granted_onchip_ram_s1,
                                   uoccl_n105_0_data_master_qualified_request_onchip_ram_s1,
                                   uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1,
                                   uoccl_n105_0_data_master_requests_onchip_ram_s1
                                );

  output           d1_onchip_ram_s1_end_xfer;
  output  [  9: 0] onchip_ram_s1_address;
  output  [ 15: 0] onchip_ram_s1_readdata_from_sa;
  output           onchip_ram_s1_reset_n;
  output  [  1: 0] onchip_ram_s1_writebyteenable;
  output  [ 15: 0] onchip_ram_s1_writedata;
  output           uoccl_n105_0_data_master_granted_onchip_ram_s1;
  output           uoccl_n105_0_data_master_qualified_request_onchip_ram_s1;
  output           uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1;
  output           uoccl_n105_0_data_master_requests_onchip_ram_s1;
  input            clk;
  input            d2_reset_n;
  input   [ 15: 0] onchip_ram_s1_readdata;
  input   [ 15: 0] uoccl_n105_0_data_master_address_to_slave;
  input   [  3: 0] uoccl_n105_0_data_master_byteenable;
  input            uoccl_n105_0_data_master_read;
  input            uoccl_n105_0_data_master_write;
  input   [ 15: 0] uoccl_n105_0_data_master_writedata;

  reg              d1_onchip_ram_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  9: 0] onchip_ram_s1_address;
  wire             onchip_ram_s1_dummy_write;
  wire             onchip_ram_s1_end_xfer;
  wire             onchip_ram_s1_in_a_read_cycle;
  wire             onchip_ram_s1_in_a_write_cycle;
  wire    [ 15: 0] onchip_ram_s1_readdata_from_sa;
  wire             onchip_ram_s1_reset_n;
  wire             onchip_ram_s1_waits_for_read;
  wire             onchip_ram_s1_waits_for_write;
  wire    [  1: 0] onchip_ram_s1_writebyteenable;
  wire    [  1: 0] onchip_ram_s1_writebyteenable_onchip_ram_s1_pre_write_qualification;
  wire    [ 15: 0] onchip_ram_s1_writedata;
  wire             p1_uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register;
  wire             uoccl_n105_0_data_master_granted_onchip_ram_s1;
  wire             uoccl_n105_0_data_master_qualified_request_onchip_ram_s1;
  wire             uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1;
  reg              uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register;
  wire             uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register_in;
  wire             uoccl_n105_0_data_master_requests_onchip_ram_s1;
  wire             wait_for_onchip_ram_s1_counter;
  assign uoccl_n105_0_data_master_requests_onchip_ram_s1 = ({uoccl_n105_0_data_master_address_to_slave[15 : 11] , 11'b0} == 16'h0) & (uoccl_n105_0_data_master_read | uoccl_n105_0_data_master_write);
  //assign onchip_ram_s1_readdata_from_sa = onchip_ram_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign onchip_ram_s1_readdata_from_sa = onchip_ram_s1_readdata;

  assign uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 = uoccl_n105_0_data_master_requests_onchip_ram_s1 & ~((uoccl_n105_0_data_master_read & ((|uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register))));
  assign uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register_in = uoccl_n105_0_data_master_granted_onchip_ram_s1 & uoccl_n105_0_data_master_read & ~onchip_ram_s1_waits_for_read & ~(|uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register);
  assign p1_uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register = {uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register, uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register <= 0;
      else if (1)
          uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register <= p1_uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register;
    end


  assign uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1 = uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1_shift_register;
  //onchip_ram_s1_writedata mux, which is an e_mux
  assign onchip_ram_s1_writedata = uoccl_n105_0_data_master_writedata;

  //master is always granted when requested
  assign uoccl_n105_0_data_master_granted_onchip_ram_s1 = uoccl_n105_0_data_master_qualified_request_onchip_ram_s1;

  //onchip_ram_s1_address mux, which is an e_mux
  assign onchip_ram_s1_address = uoccl_n105_0_data_master_address_to_slave >> 1;

  //onchip_ram_s1_dummy_write assignment, which is an e_mux
  assign onchip_ram_s1_dummy_write = uoccl_n105_0_data_master_granted_onchip_ram_s1 & uoccl_n105_0_data_master_write;

  //onchip_ram_s1_end_xfer assignment, which is an e_assign
  assign onchip_ram_s1_end_xfer = ~(onchip_ram_s1_waits_for_read | onchip_ram_s1_waits_for_write);

  //d1_onchip_ram_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_onchip_ram_s1_end_xfer <= 1;
      else if (1)
          d1_onchip_ram_s1_end_xfer <= onchip_ram_s1_end_xfer;
    end


  assign onchip_ram_s1_waits_for_read = onchip_ram_s1_in_a_read_cycle & 0;
  //onchip_ram_s1_in_a_read_cycle assignment, which is an e_assign
  assign onchip_ram_s1_in_a_read_cycle = uoccl_n105_0_data_master_granted_onchip_ram_s1 & uoccl_n105_0_data_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = onchip_ram_s1_in_a_read_cycle;

  assign onchip_ram_s1_waits_for_write = onchip_ram_s1_in_a_write_cycle & 0;
  //onchip_ram_s1_in_a_write_cycle assignment, which is an e_assign
  assign onchip_ram_s1_in_a_write_cycle = uoccl_n105_0_data_master_granted_onchip_ram_s1 & uoccl_n105_0_data_master_write;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = onchip_ram_s1_in_a_write_cycle;

  assign wait_for_onchip_ram_s1_counter = 0;
  //onchip_ram_s1_writebyteenable qualified byte write enables, which is an e_mux
  assign onchip_ram_s1_writebyteenable = ((onchip_ram_s1_dummy_write & uoccl_n105_0_data_master_granted_onchip_ram_s1))? onchip_ram_s1_writebyteenable_onchip_ram_s1_pre_write_qualification :
    0;

  //onchip_ram_s1_writebyteenable_onchip_ram_s1_pre_write_qualification mux, which is an e_mux
  assign onchip_ram_s1_writebyteenable_onchip_ram_s1_pre_write_qualification = (uoccl_n105_0_data_master_granted_onchip_ram_s1)? uoccl_n105_0_data_master_byteenable :
    -1;

  assign onchip_ram_s1_reset_n = d2_reset_n;

  // exemplar attribute onchip_ram_s1_arbitrator auto_dissolve FALSE

endmodule


module onchip_rom_s1_arbitrator (
                                  // inputs:
                                   clk,
                                   d2_reset_n,
                                   onchip_rom_s1_readdata,
                                   uoccl_n105_0_instruction_master_address_to_slave,
                                   uoccl_n105_0_instruction_master_read,

                                  // outputs:
                                   d1_onchip_rom_s1_end_xfer,
                                   onchip_rom_s1_address,
                                   onchip_rom_s1_readdata_from_sa,
                                   onchip_rom_s1_reset_n,
                                   uoccl_n105_0_instruction_master_granted_onchip_rom_s1,
                                   uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1,
                                   uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1,
                                   uoccl_n105_0_instruction_master_requests_onchip_rom_s1
                                );

  output           d1_onchip_rom_s1_end_xfer;
  output  [  9: 0] onchip_rom_s1_address;
  output  [ 15: 0] onchip_rom_s1_readdata_from_sa;
  output           onchip_rom_s1_reset_n;
  output           uoccl_n105_0_instruction_master_granted_onchip_rom_s1;
  output           uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1;
  output           uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1;
  output           uoccl_n105_0_instruction_master_requests_onchip_rom_s1;
  input            clk;
  input            d2_reset_n;
  input   [ 15: 0] onchip_rom_s1_readdata;
  input   [ 15: 0] uoccl_n105_0_instruction_master_address_to_slave;
  input            uoccl_n105_0_instruction_master_read;

  reg              d1_onchip_rom_s1_end_xfer;
  wire             in_a_read_cycle;
  wire             in_a_write_cycle;
  wire    [  9: 0] onchip_rom_s1_address;
  wire             onchip_rom_s1_end_xfer;
  wire             onchip_rom_s1_in_a_read_cycle;
  wire             onchip_rom_s1_in_a_write_cycle;
  wire    [ 15: 0] onchip_rom_s1_readdata_from_sa;
  wire             onchip_rom_s1_reset_n;
  wire             onchip_rom_s1_waits_for_read;
  wire             onchip_rom_s1_waits_for_write;
  wire             p1_uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register;
  wire             uoccl_n105_0_instruction_master_granted_onchip_rom_s1;
  wire             uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1;
  wire             uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1;
  reg              uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register;
  wire             uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register_in;
  wire             uoccl_n105_0_instruction_master_requests_onchip_rom_s1;
  wire             wait_for_onchip_rom_s1_counter;
  assign uoccl_n105_0_instruction_master_requests_onchip_rom_s1 = ({uoccl_n105_0_instruction_master_address_to_slave[15 : 11] , 11'b0} == 16'h0) & (uoccl_n105_0_instruction_master_read);
  //assign onchip_rom_s1_readdata_from_sa = onchip_rom_s1_readdata so that symbol knows where to group signals which may go to master only, which is an e_assign
  assign onchip_rom_s1_readdata_from_sa = onchip_rom_s1_readdata;

  assign uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 = uoccl_n105_0_instruction_master_requests_onchip_rom_s1 & ~((uoccl_n105_0_instruction_master_read & ((|uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register))));
  assign uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register_in = uoccl_n105_0_instruction_master_granted_onchip_rom_s1 & uoccl_n105_0_instruction_master_read & ~onchip_rom_s1_waits_for_read & ~(|uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register);
  assign p1_uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register = {uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register, uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register_in};
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register <= 0;
      else if (1)
          uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register <= p1_uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register;
    end


  assign uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1 = uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1_shift_register;
  //master is always granted when requested
  assign uoccl_n105_0_instruction_master_granted_onchip_rom_s1 = uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1;

  //onchip_rom_s1_address mux, which is an e_mux
  assign onchip_rom_s1_address = uoccl_n105_0_instruction_master_address_to_slave >> 1;

  //onchip_rom_s1_end_xfer assignment, which is an e_assign
  assign onchip_rom_s1_end_xfer = ~(onchip_rom_s1_waits_for_read | onchip_rom_s1_waits_for_write);

  //d1_onchip_rom_s1_end_xfer register, which is an e_register
  always @(posedge clk or negedge d2_reset_n)
    begin
      if (d2_reset_n == 0)
          d1_onchip_rom_s1_end_xfer <= 1;
      else if (1)
          d1_onchip_rom_s1_end_xfer <= onchip_rom_s1_end_xfer;
    end


  assign onchip_rom_s1_waits_for_read = onchip_rom_s1_in_a_read_cycle & 0;
  //onchip_rom_s1_in_a_read_cycle assignment, which is an e_assign
  assign onchip_rom_s1_in_a_read_cycle = uoccl_n105_0_instruction_master_granted_onchip_rom_s1 & uoccl_n105_0_instruction_master_read;

  //in_a_read_cycle assignment, which is an e_mux
  assign in_a_read_cycle = onchip_rom_s1_in_a_read_cycle;

  assign onchip_rom_s1_waits_for_write = onchip_rom_s1_in_a_write_cycle & 0;
  //onchip_rom_s1_in_a_write_cycle assignment, which is an e_assign
  assign onchip_rom_s1_in_a_write_cycle = 0;

  //in_a_write_cycle assignment, which is an e_mux
  assign in_a_write_cycle = onchip_rom_s1_in_a_write_cycle;

  assign wait_for_onchip_rom_s1_counter = 0;
  assign onchip_rom_s1_reset_n = d2_reset_n;

  // exemplar attribute onchip_rom_s1_arbitrator auto_dissolve FALSE

endmodule


module uoccl_n105_0_data_master_arbitrator (
                                             // inputs:
                                              d1_lcd_16207_0_control_slave_end_xfer,
                                              d1_onchip_ram_s1_end_xfer,
                                              lcd_16207_0_control_slave_readdata_from_sa,
                                              lcd_16207_0_control_slave_wait_counter_eq_0,
                                              onchip_ram_s1_readdata_from_sa,
                                              uoccl_n105_0_data_master_address,
                                              uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave,
                                              uoccl_n105_0_data_master_granted_onchip_ram_s1,
                                              uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave,
                                              uoccl_n105_0_data_master_qualified_request_onchip_ram_s1,
                                              uoccl_n105_0_data_master_read,
                                              uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1,
                                              uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave,
                                              uoccl_n105_0_data_master_requests_onchip_ram_s1,
                                              uoccl_n105_0_data_master_write,

                                             // outputs:
                                              uoccl_n105_0_data_master_address_to_slave,
                                              uoccl_n105_0_data_master_readdata,
                                              uoccl_n105_0_data_master_waitrequest
                                           );

  output  [ 15: 0] uoccl_n105_0_data_master_address_to_slave;
  output  [ 15: 0] uoccl_n105_0_data_master_readdata;
  output           uoccl_n105_0_data_master_waitrequest;
  input            d1_lcd_16207_0_control_slave_end_xfer;
  input            d1_onchip_ram_s1_end_xfer;
  input   [  7: 0] lcd_16207_0_control_slave_readdata_from_sa;
  input            lcd_16207_0_control_slave_wait_counter_eq_0;
  input   [ 15: 0] onchip_ram_s1_readdata_from_sa;
  input   [ 15: 0] uoccl_n105_0_data_master_address;
  input            uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave;
  input            uoccl_n105_0_data_master_granted_onchip_ram_s1;
  input            uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave;
  input            uoccl_n105_0_data_master_qualified_request_onchip_ram_s1;
  input            uoccl_n105_0_data_master_read;
  input            uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1;
  input            uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave;
  input            uoccl_n105_0_data_master_requests_onchip_ram_s1;
  input            uoccl_n105_0_data_master_write;

  wire             dummy_sink;
  wire             r_0;
  wire    [ 15: 0] uoccl_n105_0_data_master_address_to_slave;
  wire    [ 15: 0] uoccl_n105_0_data_master_readdata;
  wire             uoccl_n105_0_data_master_waitrequest;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = ((~uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave | ~uoccl_n105_0_data_master_read | (1 & ((lcd_16207_0_control_slave_wait_counter_eq_0 & ~d1_lcd_16207_0_control_slave_end_xfer)) & uoccl_n105_0_data_master_read))) & ((~uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave | ~uoccl_n105_0_data_master_write | (1 & ((lcd_16207_0_control_slave_wait_counter_eq_0 & ~d1_lcd_16207_0_control_slave_end_xfer)) & uoccl_n105_0_data_master_write))) & (uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 | uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1 | ~uoccl_n105_0_data_master_requests_onchip_ram_s1) & ((~uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 | ~uoccl_n105_0_data_master_read | (uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1 & uoccl_n105_0_data_master_read))) & ((~uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 | ~uoccl_n105_0_data_master_write | (1 & uoccl_n105_0_data_master_write)));

  //cascaded wait assignment, which is an e_assign
  assign uoccl_n105_0_data_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign uoccl_n105_0_data_master_address_to_slave = {uoccl_n105_0_data_master_address[15],
    4'b0,
    uoccl_n105_0_data_master_address[10 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = uoccl_n105_0_data_master_address_to_slave |
    uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave |
    uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave |
    uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave |
    d1_lcd_16207_0_control_slave_end_xfer |
    lcd_16207_0_control_slave_wait_counter_eq_0 |
    uoccl_n105_0_data_master_address_to_slave |
    uoccl_n105_0_data_master_requests_onchip_ram_s1 |
    uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 |
    uoccl_n105_0_data_master_granted_onchip_ram_s1 |
    d1_onchip_ram_s1_end_xfer;

  //uoccl_n105_0/data_master readdata mux, which is an e_mux
  assign uoccl_n105_0_data_master_readdata = ({16 {~uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave}} | lcd_16207_0_control_slave_readdata_from_sa) &
    ({16 {~uoccl_n105_0_data_master_requests_onchip_ram_s1}} | onchip_ram_s1_readdata_from_sa);


  // exemplar attribute uoccl_n105_0_data_master_arbitrator auto_dissolve FALSE

endmodule


module uoccl_n105_0_instruction_master_arbitrator (
                                                    // inputs:
                                                     d1_onchip_rom_s1_end_xfer,
                                                     d2_reset_n,
                                                     onchip_rom_s1_readdata_from_sa,
                                                     uoccl_n105_0_instruction_master_address,
                                                     uoccl_n105_0_instruction_master_granted_onchip_rom_s1,
                                                     uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1,
                                                     uoccl_n105_0_instruction_master_read,
                                                     uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1,
                                                     uoccl_n105_0_instruction_master_requests_onchip_rom_s1,

                                                    // outputs:
                                                     uoccl_n105_0_instruction_master_address_to_slave,
                                                     uoccl_n105_0_instruction_master_readdata,
                                                     uoccl_n105_0_instruction_master_reset,
                                                     uoccl_n105_0_instruction_master_waitrequest
                                                  );

  output  [ 15: 0] uoccl_n105_0_instruction_master_address_to_slave;
  output  [ 15: 0] uoccl_n105_0_instruction_master_readdata;
  output           uoccl_n105_0_instruction_master_reset;
  output           uoccl_n105_0_instruction_master_waitrequest;
  input            d1_onchip_rom_s1_end_xfer;
  input            d2_reset_n;
  input   [ 15: 0] onchip_rom_s1_readdata_from_sa;
  input   [ 15: 0] uoccl_n105_0_instruction_master_address;
  input            uoccl_n105_0_instruction_master_granted_onchip_rom_s1;
  input            uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1;
  input            uoccl_n105_0_instruction_master_read;
  input            uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1;
  input            uoccl_n105_0_instruction_master_requests_onchip_rom_s1;

  wire             dummy_sink;
  wire             r_0;
  wire    [ 15: 0] uoccl_n105_0_instruction_master_address_to_slave;
  wire    [ 15: 0] uoccl_n105_0_instruction_master_readdata;
  wire             uoccl_n105_0_instruction_master_reset;
  wire             uoccl_n105_0_instruction_master_waitrequest;
  //r_0 cascaded wait assignment, which is an e_assign
  assign r_0 = (uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 | uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1 | ~uoccl_n105_0_instruction_master_requests_onchip_rom_s1) & ((~uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 | ~uoccl_n105_0_instruction_master_read | (uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1 & uoccl_n105_0_instruction_master_read)));

  //cascaded wait assignment, which is an e_assign
  assign uoccl_n105_0_instruction_master_waitrequest = ~r_0;

  //optimize select-logic by passing only those address bits which matter.
  assign uoccl_n105_0_instruction_master_address_to_slave = {5'b0,
    uoccl_n105_0_instruction_master_address[10 : 0]};

  //dummy sink, which is an e_mux
  assign dummy_sink = uoccl_n105_0_instruction_master_address_to_slave |
    uoccl_n105_0_instruction_master_requests_onchip_rom_s1 |
    uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 |
    uoccl_n105_0_instruction_master_granted_onchip_rom_s1 |
    d1_onchip_rom_s1_end_xfer;

  //uoccl_n105_0/instruction_master readdata mux, which is an e_mux
  assign uoccl_n105_0_instruction_master_readdata = {16 {~uoccl_n105_0_instruction_master_requests_onchip_rom_s1}} | onchip_rom_s1_readdata_from_sa;

  //reset assignment, which is an e_assign
  assign uoccl_n105_0_instruction_master_reset = ~d2_reset_n;


  // exemplar attribute uoccl_n105_0_instruction_master_arbitrator auto_dissolve FALSE

endmodule


module N_105_system (
                      // 1) global signals:
                       clk,
                       reset_n,

                      // the_lcd_16207_0
                       LCD_E_from_the_lcd_16207_0,
                       LCD_RS_from_the_lcd_16207_0,
                       LCD_RW_from_the_lcd_16207_0,
                       LCD_data_to_and_from_the_lcd_16207_0
                    );

  output           LCD_E_from_the_lcd_16207_0;
  output           LCD_RS_from_the_lcd_16207_0;
  output           LCD_RW_from_the_lcd_16207_0;
  inout   [  7: 0] LCD_data_to_and_from_the_lcd_16207_0;
  input            clk;
  input            reset_n;

  wire             LCD_E_from_the_lcd_16207_0;
  wire             LCD_RS_from_the_lcd_16207_0;
  wire             LCD_RW_from_the_lcd_16207_0;
  wire    [  7: 0] LCD_data_to_and_from_the_lcd_16207_0;
  wire             always_one;
  wire             d1_lcd_16207_0_control_slave_end_xfer;
  wire             d1_onchip_ram_s1_end_xfer;
  wire             d1_onchip_rom_s1_end_xfer;
  reg              d1_reset_n_sources;
  reg              d2_reset_n;
  wire    [  1: 0] lcd_16207_0_control_slave_address;
  wire             lcd_16207_0_control_slave_begintransfer;
  wire             lcd_16207_0_control_slave_irq;
  wire             lcd_16207_0_control_slave_read;
  wire    [  7: 0] lcd_16207_0_control_slave_readdata;
  wire    [  7: 0] lcd_16207_0_control_slave_readdata_from_sa;
  wire             lcd_16207_0_control_slave_wait_counter_eq_0;
  wire             lcd_16207_0_control_slave_write;
  wire    [  7: 0] lcd_16207_0_control_slave_writedata;
  wire    [  9: 0] onchip_ram_s1_address;
  wire    [ 15: 0] onchip_ram_s1_readdata;
  wire    [ 15: 0] onchip_ram_s1_readdata_from_sa;
  wire             onchip_ram_s1_reset_n;
  wire    [  1: 0] onchip_ram_s1_writebyteenable;
  wire    [ 15: 0] onchip_ram_s1_writedata;
  wire    [  9: 0] onchip_rom_s1_address;
  wire    [ 15: 0] onchip_rom_s1_readdata;
  wire    [ 15: 0] onchip_rom_s1_readdata_from_sa;
  wire             onchip_rom_s1_reset_n;
  wire             reset_n_sources;
  wire    [ 15: 0] uoccl_n105_0_data_master_address;
  wire    [ 15: 0] uoccl_n105_0_data_master_address_to_slave;
  wire    [  3: 0] uoccl_n105_0_data_master_byteenable;
  wire             uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave;
  wire             uoccl_n105_0_data_master_granted_onchip_ram_s1;
  wire             uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave;
  wire             uoccl_n105_0_data_master_qualified_request_onchip_ram_s1;
  wire             uoccl_n105_0_data_master_read;
  wire             uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1;
  wire    [ 15: 0] uoccl_n105_0_data_master_readdata;
  wire             uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave;
  wire             uoccl_n105_0_data_master_requests_onchip_ram_s1;
  wire             uoccl_n105_0_data_master_waitrequest;
  wire             uoccl_n105_0_data_master_write;
  wire    [ 15: 0] uoccl_n105_0_data_master_writedata;
  wire    [ 15: 0] uoccl_n105_0_instruction_master_address;
  wire    [ 15: 0] uoccl_n105_0_instruction_master_address_to_slave;
  wire    [  3: 0] uoccl_n105_0_instruction_master_byteenable;
  wire             uoccl_n105_0_instruction_master_granted_onchip_rom_s1;
  wire             uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1;
  wire             uoccl_n105_0_instruction_master_read;
  wire             uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1;
  wire    [ 15: 0] uoccl_n105_0_instruction_master_readdata;
  wire             uoccl_n105_0_instruction_master_requests_onchip_rom_s1;
  wire             uoccl_n105_0_instruction_master_reset;
  wire             uoccl_n105_0_instruction_master_waitrequest;
  lcd_16207_0_control_slave_arbitrator the_lcd_16207_0_control_slave
    (
      .clk                                                                  (clk),
      .d1_lcd_16207_0_control_slave_end_xfer                                (d1_lcd_16207_0_control_slave_end_xfer),
      .d2_reset_n                                                           (d2_reset_n),
      .lcd_16207_0_control_slave_address                                    (lcd_16207_0_control_slave_address),
      .lcd_16207_0_control_slave_begintransfer                              (lcd_16207_0_control_slave_begintransfer),
      .lcd_16207_0_control_slave_read                                       (lcd_16207_0_control_slave_read),
      .lcd_16207_0_control_slave_readdata                                   (lcd_16207_0_control_slave_readdata),
      .lcd_16207_0_control_slave_readdata_from_sa                           (lcd_16207_0_control_slave_readdata_from_sa),
      .lcd_16207_0_control_slave_wait_counter_eq_0                          (lcd_16207_0_control_slave_wait_counter_eq_0),
      .lcd_16207_0_control_slave_write                                      (lcd_16207_0_control_slave_write),
      .lcd_16207_0_control_slave_writedata                                  (lcd_16207_0_control_slave_writedata),
      .uoccl_n105_0_data_master_address_to_slave                            (uoccl_n105_0_data_master_address_to_slave),
      .uoccl_n105_0_data_master_byteenable                                  (uoccl_n105_0_data_master_byteenable),
      .uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave           (uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave (uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_read                                        (uoccl_n105_0_data_master_read),
      .uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave          (uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_write                                       (uoccl_n105_0_data_master_write),
      .uoccl_n105_0_data_master_writedata                                   (uoccl_n105_0_data_master_writedata)
    );

  lcd_16207_0 the_lcd_16207_0
    (
      .LCD_E         (LCD_E_from_the_lcd_16207_0),
      .LCD_RS        (LCD_RS_from_the_lcd_16207_0),
      .LCD_RW        (LCD_RW_from_the_lcd_16207_0),
      .LCD_data      (LCD_data_to_and_from_the_lcd_16207_0),
      .address       (lcd_16207_0_control_slave_address),
      .begintransfer (lcd_16207_0_control_slave_begintransfer),
      .irq           (lcd_16207_0_control_slave_irq),
      .read          (lcd_16207_0_control_slave_read),
      .readdata      (lcd_16207_0_control_slave_readdata),
      .write         (lcd_16207_0_control_slave_write),
      .writedata     (lcd_16207_0_control_slave_writedata)
    );

  onchip_ram_s1_arbitrator the_onchip_ram_s1
    (
      .clk                                                      (clk),
      .d1_onchip_ram_s1_end_xfer                                (d1_onchip_ram_s1_end_xfer),
      .d2_reset_n                                               (d2_reset_n),
      .onchip_ram_s1_address                                    (onchip_ram_s1_address),
      .onchip_ram_s1_readdata                                   (onchip_ram_s1_readdata),
      .onchip_ram_s1_readdata_from_sa                           (onchip_ram_s1_readdata_from_sa),
      .onchip_ram_s1_reset_n                                    (onchip_ram_s1_reset_n),
      .onchip_ram_s1_writebyteenable                            (onchip_ram_s1_writebyteenable),
      .onchip_ram_s1_writedata                                  (onchip_ram_s1_writedata),
      .uoccl_n105_0_data_master_address_to_slave                (uoccl_n105_0_data_master_address_to_slave),
      .uoccl_n105_0_data_master_byteenable                      (uoccl_n105_0_data_master_byteenable),
      .uoccl_n105_0_data_master_granted_onchip_ram_s1           (uoccl_n105_0_data_master_granted_onchip_ram_s1),
      .uoccl_n105_0_data_master_qualified_request_onchip_ram_s1 (uoccl_n105_0_data_master_qualified_request_onchip_ram_s1),
      .uoccl_n105_0_data_master_read                            (uoccl_n105_0_data_master_read),
      .uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1   (uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1),
      .uoccl_n105_0_data_master_requests_onchip_ram_s1          (uoccl_n105_0_data_master_requests_onchip_ram_s1),
      .uoccl_n105_0_data_master_write                           (uoccl_n105_0_data_master_write),
      .uoccl_n105_0_data_master_writedata                       (uoccl_n105_0_data_master_writedata)
    );

  onchip_ram the_onchip_ram
    (
      .address         (onchip_ram_s1_address),
      .clk             (clk),
      .readdata        (onchip_ram_s1_readdata),
      .reset_n         (onchip_ram_s1_reset_n),
      .writebyteenable (onchip_ram_s1_writebyteenable),
      .writedata       (onchip_ram_s1_writedata)
    );

  onchip_rom_s1_arbitrator the_onchip_rom_s1
    (
      .clk                                                             (clk),
      .d1_onchip_rom_s1_end_xfer                                       (d1_onchip_rom_s1_end_xfer),
      .d2_reset_n                                                      (d2_reset_n),
      .onchip_rom_s1_address                                           (onchip_rom_s1_address),
      .onchip_rom_s1_readdata                                          (onchip_rom_s1_readdata),
      .onchip_rom_s1_readdata_from_sa                                  (onchip_rom_s1_readdata_from_sa),
      .onchip_rom_s1_reset_n                                           (onchip_rom_s1_reset_n),
      .uoccl_n105_0_instruction_master_address_to_slave                (uoccl_n105_0_instruction_master_address_to_slave),
      .uoccl_n105_0_instruction_master_granted_onchip_rom_s1           (uoccl_n105_0_instruction_master_granted_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 (uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_read                            (uoccl_n105_0_instruction_master_read),
      .uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1   (uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_requests_onchip_rom_s1          (uoccl_n105_0_instruction_master_requests_onchip_rom_s1)
    );

  onchip_rom the_onchip_rom
    (
      .address  (onchip_rom_s1_address),
      .clk      (clk),
      .readdata (onchip_rom_s1_readdata),
      .reset_n  (onchip_rom_s1_reset_n)
    );

  uoccl_n105_0_data_master_arbitrator the_uoccl_n105_0_data_master
    (
      .d1_lcd_16207_0_control_slave_end_xfer                                (d1_lcd_16207_0_control_slave_end_xfer),
      .d1_onchip_ram_s1_end_xfer                                            (d1_onchip_ram_s1_end_xfer),
      .lcd_16207_0_control_slave_readdata_from_sa                           (lcd_16207_0_control_slave_readdata_from_sa),
      .lcd_16207_0_control_slave_wait_counter_eq_0                          (lcd_16207_0_control_slave_wait_counter_eq_0),
      .onchip_ram_s1_readdata_from_sa                                       (onchip_ram_s1_readdata_from_sa),
      .uoccl_n105_0_data_master_address                                     (uoccl_n105_0_data_master_address),
      .uoccl_n105_0_data_master_address_to_slave                            (uoccl_n105_0_data_master_address_to_slave),
      .uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave           (uoccl_n105_0_data_master_granted_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_granted_onchip_ram_s1                       (uoccl_n105_0_data_master_granted_onchip_ram_s1),
      .uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave (uoccl_n105_0_data_master_qualified_request_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_qualified_request_onchip_ram_s1             (uoccl_n105_0_data_master_qualified_request_onchip_ram_s1),
      .uoccl_n105_0_data_master_read                                        (uoccl_n105_0_data_master_read),
      .uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1               (uoccl_n105_0_data_master_read_data_valid_onchip_ram_s1),
      .uoccl_n105_0_data_master_readdata                                    (uoccl_n105_0_data_master_readdata),
      .uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave          (uoccl_n105_0_data_master_requests_lcd_16207_0_control_slave),
      .uoccl_n105_0_data_master_requests_onchip_ram_s1                      (uoccl_n105_0_data_master_requests_onchip_ram_s1),
      .uoccl_n105_0_data_master_waitrequest                                 (uoccl_n105_0_data_master_waitrequest),
      .uoccl_n105_0_data_master_write                                       (uoccl_n105_0_data_master_write)
    );

  uoccl_n105_0_instruction_master_arbitrator the_uoccl_n105_0_instruction_master
    (
      .d1_onchip_rom_s1_end_xfer                                       (d1_onchip_rom_s1_end_xfer),
      .d2_reset_n                                                      (d2_reset_n),
      .onchip_rom_s1_readdata_from_sa                                  (onchip_rom_s1_readdata_from_sa),
      .uoccl_n105_0_instruction_master_address                         (uoccl_n105_0_instruction_master_address),
      .uoccl_n105_0_instruction_master_address_to_slave                (uoccl_n105_0_instruction_master_address_to_slave),
      .uoccl_n105_0_instruction_master_granted_onchip_rom_s1           (uoccl_n105_0_instruction_master_granted_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1 (uoccl_n105_0_instruction_master_qualified_request_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_read                            (uoccl_n105_0_instruction_master_read),
      .uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1   (uoccl_n105_0_instruction_master_read_data_valid_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_readdata                        (uoccl_n105_0_instruction_master_readdata),
      .uoccl_n105_0_instruction_master_requests_onchip_rom_s1          (uoccl_n105_0_instruction_master_requests_onchip_rom_s1),
      .uoccl_n105_0_instruction_master_reset                           (uoccl_n105_0_instruction_master_reset),
      .uoccl_n105_0_instruction_master_waitrequest                     (uoccl_n105_0_instruction_master_waitrequest)
    );

  uoccl_n105_0 the_uoccl_n105_0
    (
      .address_instr_fetch     (uoccl_n105_0_instruction_master_address),
      .address_mem_access      (uoccl_n105_0_data_master_address),
      .byteenable_instr_fetch  (uoccl_n105_0_instruction_master_byteenable),
      .byteenable_mem_access   (uoccl_n105_0_data_master_byteenable),
      .clk                     (clk),
      .read_instr_fetch        (uoccl_n105_0_instruction_master_read),
      .read_mem_access         (uoccl_n105_0_data_master_read),
      .readdata_instr_fetch    (uoccl_n105_0_instruction_master_readdata),
      .readdata_mem_access     (uoccl_n105_0_data_master_readdata),
      .reset                   (uoccl_n105_0_instruction_master_reset),
      .waitrequest_instr_fetch (uoccl_n105_0_instruction_master_waitrequest),
      .waitrequest_mem_access  (uoccl_n105_0_data_master_waitrequest),
      .write_mem_access        (uoccl_n105_0_data_master_write),
      .writedata_mem_access    (uoccl_n105_0_data_master_writedata)
    );

  //reset conditioning register, which is an e_register
  always @(posedge clk or negedge always_one)
    begin
      if (always_one == 0)
        begin
          d1_reset_n_sources <= 0;
          d2_reset_n <= 0;
        end
      else if (1)
        begin
          d1_reset_n_sources <= reset_n_sources;
          d2_reset_n <= d1_reset_n_sources;
        end
    end


  //always one, which is an e_assign
  assign always_one = 1;

  //reset sources mux, which is an e_mux
  assign reset_n_sources = reset_n;



endmodule


//exemplar translate_off



// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE

// AND HERE WILL BE PRESERVED </ALTERA_NOTE>


// If user logic components use Altsync_Ram with convert_hex2ver.dll,
// set USE_convert_hex2ver in the user comments section above

`ifdef USE_convert_hex2ver
`else
`define NO_PLI 1
`endif

`include "onchip_rom.v"
`include "cpu.v"
`include "uoccl_n105_0.v"
`include "onchip_ram.v"
`include "lcd_16207_0.v"

`timescale 1ns / 100ps

module test_bench ;


  wire             LCD_E_from_the_lcd_16207_0;
  wire             LCD_RS_from_the_lcd_16207_0;
  wire             LCD_RW_from_the_lcd_16207_0;
  wire    [  7: 0] LCD_data_to_and_from_the_lcd_16207_0;
  reg              clk;
  wire             lcd_16207_0_control_slave_irq;
  reg              reset_n;
  wire    [  3: 0] uoccl_n105_0_instruction_master_byteenable;


// <ALTERA_NOTE> CODE INSERTED BETWEEN HERE
//  add your signals and additional architecture here
// AND HERE WILL BE PRESERVED </ALTERA_NOTE>

  N_105_system DUT
    (
      .LCD_E_from_the_lcd_16207_0           (LCD_E_from_the_lcd_16207_0),
      .LCD_RS_from_the_lcd_16207_0          (LCD_RS_from_the_lcd_16207_0),
      .LCD_RW_from_the_lcd_16207_0          (LCD_RW_from_the_lcd_16207_0),
      .LCD_data_to_and_from_the_lcd_16207_0 (LCD_data_to_and_from_the_lcd_16207_0),
      .clk                                  (clk),
      .reset_n                              (reset_n)
    );

  initial
    clk = 1'b0;
  always
    #10 clk <= ~clk;
  
  initial 
    begin
      reset_n <= 0;
      #200 reset_n <= 1;
    end


endmodule


//exemplar translate_on