package tlh20.rmi;

import java.net.*;
import java.rmi.*;
import java.rmi.server.*;

public class PhoneticServer 
     extends UnicastRemoteObject 
     implements Phonetic
{
  public static void main (String [] args) {
    try {
      System.setSecurityManager (
            new RMISecurityManager ());

      PhoneticServer s = new PhoneticServer ();

      Naming.rebind (Phonetic.URL, s);
      System.out.println (Phonetic.URL + 
            " server running");
    }
    catch (Exception e) {
      System.out.println ("Exception: " + e);
    };
  }

  public PhoneticServer () throws RemoteException {
    super ();
  }

  private final static String [] WORDS = { "alfa",
  "bravo", "charlie", "delta", "echo", "foxtrot",
  "golf", "hotel", "India", "Juliet", "kilo",
  "Lima", "Mike", "November", "Oscar", "papa",
  "Quebec", "Romeo", "sierra", "tango", "uniform",
  "victor", "whiskey", "x-ray", "yankee", "zulu" };

  public String [] spell (String s) 
        throws RemoteException
  {
    String source = s.toUpperCase ();
    String [] reply = new String [s.length ()];
    for (int i = 0; i < s.length (); i++) {
      try {
        int w = (int) source.charAt (i) - (int) 'A';
        reply [i] = WORDS [w];
      }
      catch (Exception e) {reply [i] = "?";}
    }
    return reply;
  }
}
