public class NumberExample {

  public static void main (String [] args) {
    Number r = new Real (3.14159f),
           i = new Integer (42),
           s = r.add (i),
           j = i.add (new Integer (37));
    System.out.println ("r = " + r);     // r = 3.14159: Real
    System.out.println ("i = " + i);     // i = 42: Integer
    System.out.println ("s = " + s);     // s = 45.14159: Real
    System.out.println ("j = " + j);     // j = 79: Integer
};

};

abstract class Number {
  abstract Number add (Number n);
};

class Integer extends Number {
  int i;

  Integer (int i) {
    this.i = i;
  };

  Number add (Number n) {
    return n instanceof Integer
           ? (Number) new Integer (i + ((Integer) n).i)
           : (Number) new Real (i + ((Real) n).r);
  };

  public String toString () {
    return i + ": Integer";
  };
};

class Real extends Number {
  float r;

  Real (float f) {
    r = f;
  };

  Number add (Number n) {
    return n instanceof Integer ? new Real (r + ((Integer) n).i)
                                : new Real (r + ((Real) n).r);
  };

  public String toString () {
    return r + ": Real";
  };
};
