import java.net.*;
import java.io.*;

public class SlimeEndpoint
{
  ObjectInputStream ois;
  ObjectOutputStream oos;

  public SlimeEndpoint (InetAddress server_addr, int server_port) 
    throws IOException
  {
    Socket sock;
    InputStream is;
    OutputStream os;

    if (server_addr != null)
      {
	sock = new Socket (server_addr, server_port);
	System.out.println ("Connected to " + sock);
	is = sock.getInputStream ();
	ois = new ObjectInputStream (is);
	os = sock.getOutputStream ();
	oos = new ObjectOutputStream (os);
      }
    else
      {
	ServerSocket ss = new ServerSocket (0);
	System.out.println ("Waiting for connections on " + 
			    ss.getInetAddress () + " " +
			    ss.getLocalPort ());
	sock = ss.accept ();
	System.out.println ("Connection from " + 
			    sock.getLocalAddress () + " " +
			    sock.getLocalPort ());
	os = sock.getOutputStream ();
	oos = new ObjectOutputStream (os);
	is = sock.getInputStream ();
	ois = new ObjectInputStream (is);
      }
  }

  public void sendPacket (SlimePacket sp)
  {
    try
      {
	oos.writeObject (sp);
	oos.flush ();
      }
    catch (IOException io) 
      {
	System.out.println ("Error " + io);
	System.exit (1);
      }
  }

  public SlimePacket receivePacket ()
  {
    SlimePacket result = null;

    try
      {
	result = (SlimePacket) ois.readObject ();
      }
    catch (Exception e) 
      {
	System.out.println ("Error " + e);
	System.exit (1);
      }

    return result;
  }
}

