abstract class Transaction {
  public static int STATUS_ACTIVE = 0;
  public static int STATUS_COMMITTED = 1;
  public static int STATUS_ABORTED = 2;

  int status = STATUS_ACTIVE;

  abstract void abort ();

  abstract void commit () throws Failure;

  synchronized void waitFor () throws Failure {
    try {
      if (status == STATUS_ACTIVE) wait ();
    } catch (InterruptedException ie) {
      throw new Failure("Interrupted");
    }
  }

  synchronized void setStatus (int status) {
    this.status = status;
    notifyAll ();
  }
}
