import java.util.Vector;

class TSOTransaction extends Transaction {
  Vector os = new Vector ();
  Vector states = new Vector ();

  long id = getNextId ();

  static long nextId;

  static synchronized long getNextId () {
    return nextId ++;
  }

  boolean earlierThan (TSOTransaction other) {
    return (id < other.id);
  }

  void enter (TSOTransactorObject o,
              Object old) {
    os.addElement (o);                  
    states.addElement (old);
  }

  void abort () {
    for (int i = os.size() - 1; i >= 0; i --)
      {
        TSOTransactorObject tso;
        tso = (TSOTransactorObject) 
                        os.elementAt (i);
        tso.setState (states.elementAt (i));
      }
    setStatus (STATUS_ABORTED);
  }

  void commit () throws Failure {
    if (status != STATUS_ACTIVE) 
      throw new Failure ("Cannot commit");
    setStatus (STATUS_COMMITTED);
  }
}
