import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;


public class Drawing extends Applet {

  public void init () {
    drawing (getParameter ("title"), 
	     getParameter ("width"), getParameter ("height"));
  };

  static private String appletInfo = 
    "Simple sketching program\nPeter Robinson\nOctober 1997";

  public String getAppletInfo () {
    return appletInfo;
  };

  static private String [] [] parameterInfo = {
    {"title", "String", "Title for window banner"},
    {"width", "int", "Width of drawing area"},
    {"height", "int", "Height of drawing area"}
  };

  public String [] [] getParameterInfo () {
    return parameterInfo;
  };

  public void paint (Graphics g) {
    g.drawString ("Use the other frame!", 20, 30);
  };

  public static void main (String [] args) {
    System.out.println (appletInfo);
    drawing (args.length > 0 ? args [0] : "Drawing example program",
	     args.length > 1 ? args [1] : null,
	     args.length > 2 ? args [2] : null);
  };

  static void drawing (String title, String width, String height) {
    try {
      new DrawingFrame (title == null ? "Drawing example" : title,
			width == null ? 300 :
			                new Integer (width) .intValue (),
			height == null ? 250 :
			                 new Integer (height) .intValue ());
    }
    catch (NumberFormatException e) {
      System.out.println (
	"Usage: java DrawingExample [title [width [height]]]");
    };
  };

};


class DrawingFrame extends Frame {

  private static String [] [] menus = {
    {"File", "New", null, "Load", "Save", null, "Print", null, "Quit"},
    {"Colour", "Black", "Blue", "Red", "Green"},
    {"Fill", "On", "Off"}
  };    

  private int width, height;

  DrawingFrame (String title, int width, int height) {

    super (title);

    this.width = width;
    this.height = height;

    ScrollPane pane = new ScrollPane (ScrollPane.SCROLLBARS_ALWAYS);
    this.add (pane, "Center");
    DrawingCanvas canvas = new DrawingCanvas (this, 2 * width, 2 * height);
    pane.add (canvas);

    MenuBar menubar = new MenuBar ();
    this.setMenuBar (menubar);

    for (int c = 0; c < menus.length; c++) {
      Menu m = new Menu (menus [c][0]);
      menubar.add (m);
      for (int r = 1; r < menus [c] .length; r++) {
	if (menus [c][r] == null) m.addSeparator ();
	else {
	  MenuItem i = new MenuItem (menus [c][r]);
	  m.add (i);
	  i.setActionCommand (menus [c][r] .toLowerCase ());
	  i.addActionListener (canvas);
	};
      };
    };

    this.pack ();
    this.show ();

  };

  public Dimension getPreferredSize () {
    return new Dimension (width, height);
  };

};


class DrawingCanvas extends Canvas implements ActionListener {

  private Frame frame;
  private int width, height;
  private Vector drawing = new Vector ();

  class Splodge implements Serializable {
    Color color;
    boolean filled;
    Polygon polygon;
    Splodge (Color c, boolean f, Polygon p) {
      color = c;  filled = f;  polygon = p;
    };
  };

  Color color = Color.black;
  boolean filled = false;
  Polygon polygon;

  void XORpolygon () {
    Graphics g = this.getGraphics ();
    g.setXORMode (this.getBackground ());
    g.setColor (color);
    if (filled) g.fillPolygon (polygon);
    else g.drawPolygon (polygon);
  };
  
  class DCMouseAdapter extends MouseAdapter {
      public void mousePressed (MouseEvent e) {
	polygon = new Polygon ();
	polygon.addPoint (e.getX (), e.getY ());
	XORpolygon ();
      }
      public void mouseReleased (MouseEvent e) {
	XORpolygon ();
	polygon.addPoint (e.getX (), e.getY ());
	drawing.addElement (new Splodge (color, filled, polygon));
	repaint ();
      }
  }
  
  class DCMouseMotionAdapter extends MouseMotionAdapter {
      public void mouseDragged (MouseEvent e) {
	XORpolygon ();
	polygon.addPoint (e.getX (), e.getY ());
	XORpolygon ();
      }
  }

  DrawingCanvas (Frame frame, int width, int height) {
    this.frame = frame;
    this.width = width;
    this.height = height;
    this.addMouseListener (new DCMouseAdapter ());
    this.addMouseMotionListener (new DCMouseMotionAdapter ());
  }

  public Dimension getPreferredSize () {
    return new Dimension (width, height);
  };

  public void paint (Graphics g) {
    g.setPaintMode ();
    for (int d = 0; d < drawing.size (); d++) {
      Splodge s = (Splodge) drawing.elementAt (d);
      g.setColor (s.color);
      if (s.filled) g.fillPolygon (s.polygon);
      else g.drawPolygon (s.polygon);
    };
  };

  public void actionPerformed (ActionEvent e) {
    String s = e.getActionCommand ();
    if (s.equals ("new")) {
      drawing.removeAllElements ();
      this.repaint ();
    }
    else if (s.equals ("load")) load ();
    else if (s.equals ("save")) save ();
    else if (s.equals ("print")) print ();
    else if (s.equals ("quit")) System.exit (0);
    else if (s.equals ("black")) color = Color.black;
    else if (s.equals ("blue")) color = Color.blue;
    else if (s.equals ("red")) color = Color.red;
    else if (s.equals ("green")) color = Color.green;
    else if (s.equals ("on")) filled = true;
    else if (s.equals ("off")) filled = false;
  };

  private void load () {
    FileDialog fd = new FileDialog (frame, "Load drawing", FileDialog.LOAD);
    fd.show ();
    String f = fd.getFile ();
    if (f != null) {
      try {
	FileInputStream s = new FileInputStream (f);
	ObjectInputStream o = new ObjectInputStream (s);
	Vector v = (Vector) o.readObject ();
	o.close ();
	drawing = v;
	this.repaint ();
      }
      catch (Exception e) {System.out.println (e);};
    };
  };

  private void save () {
    FileDialog fd = new FileDialog (frame, "Save drawing", FileDialog.SAVE);
    fd.show ();
    String f = fd.getFile ();
    if (f != null) {
      try {
	FileOutputStream s = new FileOutputStream (f);
	ObjectOutputStream o = new ObjectOutputStream (s);
	o.writeObject (drawing);
	o.flush ();
	o.close ();
      }
      catch (Exception e) {System.out.println (e);};
    };
  };

  private static Properties preferences = new Properties ();

  private void print () {
    Toolkit toolkit = this.getToolkit ();
    PrintJob printjob = toolkit.getPrintJob (frame, "Print drawing",
				             preferences);
    if (printjob == null) return;
    Graphics sheet = printjob.getGraphics ();
    Dimension canvassize = this.getSize ();
    Dimension pagesize = printjob.getPageDimension ();
    sheet.translate ((pagesize.width - canvassize.width) / 2,
		     (pagesize.height - canvassize.height) / 2);
    sheet.drawRect (-1, -1, canvassize.width + 1, canvassize.height + 1);
    sheet.setClip (0, 0, canvassize.width, canvassize.height);
    this.print (sheet);
    sheet.dispose ();
    printjob.end ();
  };

}

