import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public class GUIExample extends Frame {
  TextField number;
  Button square;
  TextField result;

  public GUIExample () {
    number = new TextField ();
    square = new Button ("Square");
    result = new TextField ();

    number.setColumns (10);
    square.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent ae) {
        try {
          int n = Integer.decode (number.getText ()) .intValue ();
          result.setText (n * n + "");
        }
        catch (NumberFormatException nfe) {
          result.setText ("Format error");
        };
      };
    });
    result.setColumns (10);
    result.setEditable (false);

    setLayout (new BorderLayout ());
    add ("North", number);
    add ("Center", square);
    add ("South", result);
    pack ();
  }

  public static void main (String args[]) {
    GUIExample ge = new GUIExample ();
    ge.setVisible(true);
  }
}

