public class ThreadExample {

  final static int count = 5;

  public static void main (String [] args) {
    Evaluator [] workers = new Evaluator [count];
    for (int i = 0; i < count; i++) {
      workers [i] = new Evaluator (i);
      workers [i].start ();
    };
    int sum = 0;
    for (int i = 0; i < count; i++) {
      try {
	workers [i].join ();
	sum += workers [i].result;
      }
      catch (InterruptedException e) {
	System.out.println ("Interrupted while waiting for thread " + i);
      };
    };
    System.out.println ("Sum = " + sum);
  };

};

class Evaluator extends Thread {
  int argument, result;
  Evaluator (int a) {argument = a;};
  public void run () {result = argument * argument;};
};
