// Count words on named files or standard input

import java.io.*;

class WordCount {

   public static void main (String [] args)
   {
      try {
         if (args.length == 0) count ("Standard input", System.in);
         else {
            for (int a = 0; a < args.length; a++) {
               try {
                  InputStream is = new FileInputStream (args [a]);
                  count (args [a], is);
               }
               catch (FileNotFoundException e) {
                  System.err.println ("Unable to open " + args [a]);
               };
            };
         };
      }
      catch (IOException e) {
         System.err.println ("IOException " + e.getMessage ());
      };
   };

   private static void count (String name, InputStream in)
      throws IOException
   {
      int words = 0, lines = 0;
      boolean inWord = false;
      DataInputStream dis = new DataInputStream (in);
      try {
         for (;;) {
            char ch = (char) dis.readByte ();
            switch (ch) {
               case '\n':
                  lines++;
               case ' ':
               case '\t':
                  if (inWord) {
                     words++;
                     inWord = false;
                  };
                  break;
               default:
                  inWord = true;
                  break;
            };
         };
      }
      catch (EOFException e) {
         if (inWord) words++;
         System.out.println (name + " contains " + words +
            " words in " + lines + " lines.");
      };
   }

}

