import table.*;

class TableTest {

  public static void main (String [] args) {
    TryTable table = new TryTable (2);

    table.tryStore ("lcp", "Larry");
    table.tryStore ("pr", "Peter");
    table.tryStore ("acn", "Arthur");
    table.tryRetrieve ("pr");
    table.tryRetrieve ("jcw");
    table.tryStore ("jwc", "Jenni");
    table.tryStore ("lcp", "Lawrence");
    table.tryRetrieve ("jwc");
  };
};



class TryTable extends Table {
  TryTable (int size) {
    super (size);
  };

  void tryStore (String key, String value) {
    try {
      store (key, value);
      System.out.println ("Successfully stored (" + key + ", " + value + ")");
    }
    catch (DuplicateException e) {
      System.out.println ("Failed: " + e.getMessage ());
    };
  };

  void tryRetrieve (String key) {
    try {
      System.out.println ("Successfully retrieved (" + key + ", " + retrieve (key) + ")");
    }
    catch (MissingException e) {
      System.out.println ("Failed: " + e.getMessage ());
    };
  };

};



