public class HammingExample {

  static final int [] primes = {2, 3, 5};
  static final int LIMIT = 100;

  public static void main (String [] args) {
    Minimum min = new Minimum (primes.length);
    Broadcast bc = new Broadcast (primes.length);
    Thread [] hammers = new Thread [primes.length];
    for (int p = 0; p < primes.length; p++) {
      hammers [p] = new Hammer (min, bc, primes [p]);
      hammers [p] .start ();
    };
    try {
      for (;;) {
	int next = min.get ();
	if (next > LIMIT) break;
	bc.put (next);
	System.out.println (next);
      };
    }
    catch (InterruptedException e) {};
    for (int p = 0; p < primes.length; p++) {
      hammers [p] .interrupt ();
    };
  };

};

class Minimum {

  static final int INFINITY = 0x7fffffff;

  int value;
  int samples;
  int remaining = 0;

  Minimum (int s) {samples = s;};

  synchronized void put (int v) throws InterruptedException {
    while (remaining == 0) wait ();
    if (v < value) value = v;
    remaining--;
    notify ();
  };

  synchronized int get () throws InterruptedException {
    value = INFINITY;
    remaining = samples;
    notifyAll ();
    while (remaining > 0) wait ();
    return value;
  };

};

class Broadcast {

  int value;
  int clients;
  int remaining = 0;

  Broadcast (int c) {clients = c;};

  synchronized int get () throws InterruptedException {
    while (remaining == 0) wait ();
    remaining--;
    notify ();
    return value;
  };

  synchronized void put (int v) throws InterruptedException {
    value = v;
    remaining = clients;
    notifyAll ();
    while (remaining > 0) wait ();
  };

};

class Cell {
  int number;
  Cell rest = null;
  Cell (int i) {number = i;};
};

class Hammer extends Thread {
  Minimum min;
  Broadcast bc;
  int prime;
  Hammer (Minimum m, Broadcast b, int p) {min = m; bc = b; prime = p;};
  public void run () {
    Cell first = new Cell (1);
    Cell last = first;
    try {
      for (;;) {
        min.put (first.number);
	int next = bc.get ();
        last.rest = new Cell (next * prime);
        last = last.rest;
        if (first.number == next) first = first.rest;
      };
    }
    catch (InterruptedException e) {};
  };
};
