structure RegTools = struct	
 datatype value = DWORD of Int32.int | STRING of string  | ESTRING of string
 datatype modifier = CREATE | ADD
 local 
     open Microsoft.Win32
     open System.Environment
 in
     val novalues = [] : (string * value) list

     fun createkey(SOME root,[]) = root
       | createkey(SOME root,(k:string)::ks) = 
	 let val k = root.#CreateSubKey(k) 
	 in	
	    createkey(k,ks)
	 end	

     (* delete new key or all new values of an existing key *)
     fun deletekey(SOME (root:RegistryKey),newkey,[],values) = 
	 List.app (fn (name,_) => root.#DeleteValue(SOME name) handle _ => ()) values
       | deletekey(SOME root,CREATE,[k],values) = 
	(let val (_ :RegistryKey option) = root.#CreateSubKey(k) (*@HACK: we create the key just so we can delete it*)
         in root.#DeleteSubKeyTree(k) handle _ => ()
	 end)
       | deletekey(SOME root,newkey,(k:string)::ks,values) = 
	 let val k = root.#CreateSubKey(k) 
	 in
	    deletekey(k,newkey,ks,values)
	 end	

     fun setvalue (k:RegistryKey) (name:string,DWORD i) = 
	k.#SetValue(SOME name,(i :> object))
       | setvalue k (name,STRING s) = k.#SetValue(SOME name,s :> object)
       | setvalue k (name,ESTRING s) = k.#SetValue(SOME name,(valOf(ExpandEnvironmentVariables s)):> object)

     fun register (root,newkey,path,values) = 
	 let 
	     val key = createkey(root,path)	
	 in 
	     List.app (setvalue key) values;
	     key.#Close()
	 end	

     fun unregister (root,newkey,path,values) = 
	 deletekey(root,newkey,path,values)

     fun findkey(SOME (root:RegistryKey),[]) = root
       | findkey(SOME root,(k:string)::ks) = 
	 let val k = root.#OpenSubKey(k) 
	 in	
	    findkey(k,ks)
	 end	

     fun iskey(SOME (root:RegistryKey),[]) = true
       | iskey(NONE,_) = false
       | iskey(SOME root,(k:string)::ks) = 
	 let val k = root.#OpenSubKey(k) 
	 in	
	    iskey(k,ks)
	 end	



 fun expand s = valOf(ExpandEnvironmentVariables (SOME s))

 (* location of this executable, usefull for determining smlnetpath *)
 fun getPath path = 
	let val SOME assembly =  System.Reflection.Assembly.GetExecutingAssembly()
	    val SOME file =  assembly.#get_Location()
	in
	    OS.Path.mkCanonical(OS.Path.concat(file,path))
	end	

 end	
end



