// Entry point for the wizard process itself.
// used for both dlls and exes

var strOutputExt = wizard.FindSymbol("SMLNET_OUTPUTEXT") //.exe or .dll
var strTarget= wizard.FindSymbol("SMLNET_TARGET") //exe or library

// Get SMLNETPATH
var Shell = new ActiveXObject('WScript.Shell');
var Env = Shell.Environment("PROCESS");
var SMLNETPATH = Shell.RegRead("HKEY_LOCAL_MACHINE\\SOFTWARE\\SML.NET\\SMLNETPATH");
wizard.AddSymbol('SMLNETPATH',SMLNETPATH);
var smlnetdotbat = "smlnet.bat";
var smlnetcleandotbat = "smlnetclean.bat";



function OnFinish(selProj, selObj)
{


	try
	{
		var strProjectPath = wizard.FindSymbol("PROJECT_PATH");
		var strProjectName = wizard.FindSymbol("PROJECT_NAME");

		selProj = CreateProject(strProjectName, strProjectPath);
		selProj.Object.Keyword = "MakeFileProj";

		AddConfig(selProj.Object, strProjectName);
		SetSmlFilters(selProj);

		AddSmlFiles(selProj, strProjectName, strProjectPath);

		selProj.Object.Save();

	}
	catch(e)
	{
		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

// Configures the various settings for the makefile project, including
// build commands.
function AddConfig(proj, strProjectName)
{
	try
	{

                // Debug Configuration
		var config = proj.Configurations("Debug");
		config.IntermediateDirectory = "Debug";
		config.OutputDirectory = "Debug";
		config.ConfigurationType = typeUnknown;

		// TODO: change this for your own compiler's build & clean lines.
		// Note that you may wish to have different commands for release and
		// debug configurations.

		var strOutput = strProjectName + strOutputExt;

		var strCommandLine = 
	              smlnetdotbat+" /on:debug" +
	              " /target:" + strTarget +
                      " /out:" + config.OutputDirectory +  "\\" + strOutput + 
                      " @script";

	        var strBuildCommandLine = strCommandLine + " /make";
		var strCleanCommandLine = smlnetcleandotbat;
		var strReBuildCommandLine = strCommandLine + " /remake";

		var NMakeTool = config.Tools("VCNMakeTool");
        	NMakeTool.Output = config.OutputDirectory +  "\\" + strOutput;
		NMakeTool.BuildCommandLine = strBuildCommandLine;
		NMakeTool.CleanCommandLine = strCleanCommandLine;
		NMakeTool.ReBuildCommandLine = strReBuildCommandLine;

	        // Debug settings
                debugSettings = config.DebugSettings;
	        debugSettings.Attach = false;
                debugSettings.DebuggerType = TypeOfDebugger.DbgManagedOnly; 
	        if (strOutputExt == ".exe") {
        	  debugSettings.Command = 
	              config.OutputDirectory + "\\" + strOutput;
                }
	        else {
         	  debugSettings.Command = "";
	        };

                // Release Configuration
		config = proj.Configurations("Release");
		config.IntermediateDirectory = "Release";
		config.OutputDirectory = "Release";
		config.ConfigurationType = typeUnknown;

		var strOutput = strProjectName + strOutputExt;

		var strCommandLine = 
	              smlnetdotbat +
	              " /target:" + strTarget +
                      " /out:" + config.OutputDirectory +  "\\" + strOutput + 
                      " @script";

	        var strBuildCommandLine = strCommandLine + " /make";
		var strCleanCommandLine = smlnetcleandotbat;
		var strReBuildCommandLine = strCommandLine + " /remake";


		NMakeTool = config.Tools("VCNMakeTool");
		NMakeTool.Output = config.OutputDirectory +  "\\" + strOutput;
		NMakeTool.BuildCommandLine = strBuildCommandLine;
		NMakeTool.CleanCommandLine = strCleanCommandLine;
		NMakeTool.ReBuildCommandLine = strReBuildCommandLine;

	        // Debug settings
                debugSettings = config.DebugSettings;
	        debugSettings.Attach = false;
                debugSettings.DebuggerType = TypeOfDebugger.DbgManagedOnly;
	        if (strOutputExt == ".exe") {
        	  debugSettings.Command = 
	              config.OutputDirectory + "\\" + strOutput;
                }
	        else {
         	  debugSettings.Command = "";
	        };
	}
	catch(e)
	{
		throw e;
	}
}

// Sets up virtual folders in the project system (not reflected on disk) that will
// be seen in the Solution Explorer when the user adds files to the project.
function SetSmlFilters(oProj)
{
	try
	{
		var strSrcFilter = "sml;fun;sig;smlnet";
		var L_strSource_Text = "Source Files";
		var group = oProj.Object.AddFilter(L_strSource_Text);
		group.Filter = strSrcFilter;
	}
	catch(e)
	{   
		throw e;
	}
}

// Copy all files from the template directory into the project and add them
// as project items. Note that the filters previously applied will filter the
// files into their appropriate virtual folders.
function AddSmlFiles(oProj, strProjectName, strProjectPath)
{
	try
	{
		var projFile, window;
		var strTemplatePath = wizard.FindSymbol("TEMPLATES_PATH");


	        if (strTarget == "exe") 
		    AddSmlFile(oProj, strProjectPath, strTemplatePath, strProjectName + ".sml", "Main.sml");
	        if (strTarget == "library") 
     		    AddSmlFile(oProj, strProjectPath, strTemplatePath, strProjectName + ".sml", "Lib.sml");
		AddSmlFile(oProj, strProjectPath, strTemplatePath, "README.html","README.html");
		AddSmlFile(oProj, strProjectPath, strTemplatePath, "script.smlnet","script.smlnet");
	}
	catch(e)
	{   
		throw e;
	}
}

function AddSmlFile(oProj, strProjectPath, strTemplatePath, strTarget, strSource)
{
	try
	{
		var projfile;
		var strFile = strProjectPath + '\\' + strTarget;
		
		wizard.RenderTemplate(strTemplatePath + '\\' + strSource, strFile, false, false);
		projfile = oProj.Object.AddFile(strFile);
		
		return projfile;
	}
	catch(e)
	{
		throw e;
	}
}
