(*----------------------------------------------------------------------*)
(* Miscellaneous stuff to do with option types				*)
(*----------------------------------------------------------------------*)
structure OptionOps =
struct

(*----------------------------------------------------------------------*)
(* Convert a value of type 'a option into one of type 'a list		*)
(*----------------------------------------------------------------------*)
fun toList NONE = []
  | toList (SOME v) = [v]

(*----------------------------------------------------------------------*)
(* Option-returning list head						*)
(*----------------------------------------------------------------------*)
fun hd [] = NONE
  | hd (x::xs) = SOME x

(*----------------------------------------------------------------------*)
(* Optional application						        *)
(*----------------------------------------------------------------------*)
fun app f NONE = ()
  | app f (SOME x) = f x


end
