/*  -*- Mode: C;  -*-
 * File: jroute.h
 * Author: James Hall (jch1003@cl.cam.ac.uk)
 * Copyright (C) University of Cambridge Computer Laboratory, 1998
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** PACKAGE: jroute
 **
 ** FUNCTION: header
 **
 ** HISTORY:
 ** Created: Tue Aug 11 16:05:07 1998 (jch1003)
 ** Last Edited: Tue Nov  3 15:59:54 1998 By James Hall
 **
    $Log: jroute.h,v $
    Revision 1.12  2001/10/25 13:48:03  iap10
    *** empty log message ***

    Revision 1.11  1998/11/11 12:52:52  jch1003
    *** empty log message ***

    Revision 1.10  1998/10/27 10:54:50  iap10
    *** empty log message ***

    Revision 1.9  1998/10/20 22:30:40  iap10
    *** empty log message ***

    Revision 1.7  1998/10/12 10:31:05  iap10
    *** empty log message ***

    Revision 1.6  1998/10/09 14:38:21  iap10
    ..

    Revision 1.5  1998/10/09 12:11:27  jch1003
    *** empty log message ***

    Revision 1.4  1998/09/01 15:40:27  iap10
    *** empty log message ***

    Revision 1.3  1998/08/14 11:46:32  jch1003
    *** empty log message ***

 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */


#ifndef __JROUTE_H__
#define  __JROUTE_H__

typedef unsigned short uint16;
typedef unsigned int uint32;

#define MAX_INDATA_SZ 1000
#define CL_BUFSZ 1024
#define TIMEOUT_BASE_SEC_DEF 1
#define ICMP_BUFSZ 512

#ifndef MIN
#define MIN(x, y) ((x)>(y)?(y):(x))
#endif

#ifndef MAX
#define MAX(x, y) ((x)<(y)?(y):(x))
#endif

/* 
 * if NPROBES_MAX > NPROBES_AGREE probes are polled until the specified 
 * number agree, up to the specified maximum attempts 
 */
#define NPROBES_AGREE 3
#define NPROBES_MAX 3

#define TTL_MAX_DEF 40
#define TTL_MAX 128
#define TTL_MIN_DEF 1

#define TTL_REACHABLE 255	/* should reach anywhere */

#define ADDR_POOL_SZ_FACT 20	/* ADDR_POOL_SZ_FACT*nthreads = pool size */

#define NO_BLOCK 0
#define BLOCK 1

#define TNET_INBUF_SZ 1024

#define N_CONTEXTS 256

#define PROBE_TCP   0            /* program operation mode */
#define PROBE_ICMP  1

/* max ttl*nprobes product - must be 2**n */
#define MAX_TTL_PROBES 512
/* max retries to get a port - must be 2**(15-n) */
#define MAX_PORT_RETRYS 10
/* shifts for port regets - must be n */
#define PORT_GET_SHIFTS 9
#define MAX_SEQ MAX_TTL_PROBES

/* extract the probing thread from its snd port no. */
#define WHICH_RTHREAD(p) ((p)>>PORT_GET_SHIFTS & 0x3f)

typedef union
{
  uint32 addrint;
  struct in_addr addrin;
} addr_un_t;

struct ifaddrlist 
{
  uint32 addr;
  char *device;
};

struct hostinfo 
{
  char *name;
  int n;
  uint32 *addrs;
};

/* structure to hold lsr info */
typedef struct src_route
{
  uint32     num;
  uint32     ptr;
  addr_un_t  rt[10];
} src_route_t;

/* holds results of a probe */
typedef struct probe_res 
{
  addr_un_t addr;
  uint32 status;
  uchar ret_ttl;
} probe_res_t;

/* holds results of probes for a particular ttl - enables majority poll */
typedef struct ttl_res 
{
  int nprobes;			/* how many sent */
  probe_res_t probe[NPROBES_MAX];	/* results */
} ttl_res_t;

/* holds context for route determination */
typedef struct rcontext 
{
  int ttl_min;
  int ttl_max;
  src_route_t route;
#define CONTEXT_NM_SZ 25
  char cnm[CONTEXT_NM_SZ];
} rcontext_t;

/* linked list item for contexts */
typedef struct conlist 
{
  list_t link;
  rcontext_t con;
} conlist_t;
  

/* holds results of tracing route to an address */
typedef struct addr_train 
{
  addr_un_t dest;		/* where we're going to */
  uint16 port;
  rcontext_t con;
  src_route_t route_oif;
  int nhops;			/* number of hops */
  addr_un_t hops[TTL_MAX];	/* array of hop addresses */
  uint32 status;
  int in_use;
#define VACANT 0
#define VALID 1
#define IN_USE 2
  int sent, srsent, srcd;		/* probes sent and syn pkts received */
  int iphlen;
  int tcplen;
#define TR_LABEL_LEN 25
  char label[TR_LABEL_LEN];
} addr_train_t;

/* codes for probe and ttl status */

#define PORT_UNREACH 0x1
#define PROT_UNREACH 0x2
#define NET_UNREACH 0x4
#define HOST_UNREACH 0x8
#define NEEDFRAG_UNREACH 0x10
#define SRCFAIL_UNREACH 0x20
#define PROHIB_UNREACH 0x40 
#define OTHER_UNREACH 0x80


#define NO_REACH 0x1ff		/* all the above */
// #define UNREACHABLE(status) ((status) & NO_REACH)

/* MAJOR train ststus codes */
#define UNREACHABLE      0x100 /* no response from host after timeouts */
#define EXPIRED          0x200 /* reached max TTL without error or success */
#define ERROR            0x400 /* routing error e.g. loop */
#define GOT_THERE        0x800 /* OK, success */
#define GIVEUP          0x1000 /* Giveup, too many ***'s in a row */

#define TTL_EXCEEDED 0x2000
#define TIMED_OUT 0x4000
#define TIME_OUTS 0x8000

#define AGREEMENT 0x10000
#define NO_AGREEMENT 0x20000

#define RELAXED 0x100000
#define BOGUS_ADDR 0x200000
#define DUP_HOPS_SUBST   0x400000
#define INFERRED_DOUBLE  0x800000
#define POSSIBLE_DOUBLE 0x1000000
#define LOOP            0x2000000
#define DUP_HOPS_STRIP  0x4000000

#define NOTEABLE 0x700000
#define TAKE_NOTE(status) ((status) & NOTEABLE)

/*
 * Telnet codes and states 
 */

typedef enum { STATE_NORMAL, STATE_IAC, STATE_OPT } state_t;
#define IAC   0xff
#define  SE   240  /*    End of subnegotiation parameters. */
#define NOP   241  /*    No operation. */
#define DMARK 242  /*    The data stream portion of a Synch. */
#define BRK   243  /*    NVT character BRK. */
#define  IP   244  /*    The function IP (interrupt process) */
#define  AO   245  /*    The function AO (abort output). */
#define AYT   246  /*    The function AYT (Are You There). */
#define  EC   247  /*    The function EC. (Erase Character) */
#define  EL   248  /*    The function EL. (Erase Line) */
#define  GA   249  /*    The GA signal. (Go Ahead) */
#define  SB   250  /*    sub-negotiation start */
#define WILL  251
#define WONT  252
#define  DO   253
#define DONT  254
/* options */
#define TMARK   6  /* time mark */
#define LINEMODE   34  /* time mark */

/*
 * jroute.c 
 */

extern int s;		/* receive (icmp) socket file descriptor */  
extern int probe_type;
extern int main_pid;
extern char *prog;
extern int verbose;
extern int simple_output;
extern int sort;
extern int naddr;
extern int naddr_done;
extern int nthreads;
extern int (*get)();
void error(char *msg);
void error2(char *msg1, char *msg2);
int get_stdio(char *buf, FILE *i);
int get_tnet(char *obuf, FILE *infile);

/*
 * jroute_util.c 
 */
extern FILE *ofile;
FILE *open_ofile(char *fn, int mode);
struct hostinfo *gethostinfo(register char *hostname);
int ifaddrlist(struct ifaddrlist **, char *);
char *savestr(const char *);
void setsin(register struct sockaddr_in *sin, register uint32 addr);
void tvsub(struct timeval *, struct timeval *);
void print_train(FILE *f, int me, addr_train_t *tr, int lock); 
void pretty_print_trains(FILE *f, addr_train_t *all_addrs, int naddr, 
			 int ditto);
void print_probe_status(FILE *f, int me, probe_res_t *pr, int nprobes);
int cmp_train(const void *key, const void *item);
int fdset_is_zero(fd_set *s);
int parseroute( src_route_t * route, char * list);
char *intoa(uint32 addr);
char *get_hname(char *ap);

/*
 * getroute.c
 */

extern int giveup, maxrate;
extern rcontext_t con_def;
extern struct timeval start;

src_route_t route;

#if 0
/*
 * context.c
 */
extern list_t clist[N_CONTEXTS];
void clist_init(list_t *l);
int add_to_clist(list_t *l, conlist_t *c);
#endif

#endif /*  __JROUTE_H__ */
