#!/bin/bash
# Copyright (c) 2016, Gianni Antichi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the project, the copyright holder nor the names of its
#  contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

export $PCIEBENCH_SW=/root/virtex7-pcie-benchmark/HOST/

tmp_file="tmp.txt" 	# Temporal file with all the outputs of the benchmark program
			# the valid information will be dumped on a different file

iters=10000		# number of iterations

rm $file1
out_file="out.txt"

for i in 8 16 24 32 48 64 128 256 512 768 1024 1280 1520 2048
do
	for iter in $(seq 1 $iters);
	do
		sh $PCIEBENCH_SW/restart.sh; $PCIEBENCH_SW/bin/benchmark -t lat -f $out_file -d W -p FIX 0 -c warm -n $i -l 1000
		tail -n 1 $tmp_file | awk 'BEGIN{FS=","}{print '$i',$4,$5}'>>$out_file
	done
done
