/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ActivateLicenseResponse;
import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.CancelSpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.CustomerGatewayDescription;
import com.amazon.aes.webservices.client.DeactivateLicenseResponse;
import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import com.amazon.aes.webservices.client.EbsVolumeDescription;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.ImageMapAttribute;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.ImageValueAttribute;
import com.amazon.aes.webservices.client.ImportInstanceConversionTask;
import com.amazon.aes.webservices.client.ImportInstanceVolumeDetail;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingResponseDescription;
import com.amazon.aes.webservices.client.InstanceLicense;
import com.amazon.aes.webservices.client.InstanceStateChangeDescription;
import com.amazon.aes.webservices.client.InternetGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.InternetGatewayDescription;
import com.amazon.aes.webservices.client.License;
import com.amazon.aes.webservices.client.LicenseCapacity;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.NetworkAclAssociationDescription;
import com.amazon.aes.webservices.client.NetworkAclDescription;
import com.amazon.aes.webservices.client.NetworkAclEntryDescription;
import com.amazon.aes.webservices.client.RecurringCharge;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.ReservedInstancesOfferingDescription;
import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazon.aes.webservices.client.RouteDescription;
import com.amazon.aes.webservices.client.RouteTableAssociationDescription;
import com.amazon.aes.webservices.client.RouteTableDescription;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.SnapshotListAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttributeItem;
import com.amazon.aes.webservices.client.SpotDatafeedSubscription;
import com.amazon.aes.webservices.client.SpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.SpotPriceHistoryDescription;
import com.amazon.aes.webservices.client.SubnetDescription;
import com.amazon.aes.webservices.client.TagDescription;
import com.amazon.aes.webservices.client.UserIdGroupPair;
import com.amazon.aes.webservices.client.VgwTelemetryDescription;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.VpnConnectionDescription;
import com.amazon.aes.webservices.client.VpnGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.VpnGatewayDescription;
import com.amazon.aes.webservices.client.instanceStatus.Event;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusDescription;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import sun.misc.BASE64Decoder;

public class Outputter {
    public static final String VPN_GATEWAY = "vpn-gateway";
    public static final String SPOT_INSTANCE_REQUEST = "spot-instance-request";
    public static final String VPN_CONNECTION = "vpn-connection";
    public static final String CUSTOMER_GATEWAY = "customer-gateway";
    public static final String SUBNET = "subnet";
    public static final String VPC = "vpc";
    public static final String SNAPSHOT = "snapshot";
    public static final String RESERVED_INSTANCES = "reserved-instances";
    public static final String VOLUME = "volume";
    public static final String IMAGE = "image";
    public static final String LICENSE = "license";
    public static final String INSTANCE = "instance";
    public static final String DHCP_OPTIONS = "dhcp-options";
    private static String FIELDSEP = "\t";
    private static String NULLFIELD = "(nil)";
    private static String EMPTY_STRING = "";
    private static int SECONDS_IN_YEAR = 31536000;
    private static int SECONDS_IN_MONTH = 2592000;
    private boolean showHeaders;
    private boolean showDebug;
    private boolean showNullFields;
    private boolean showRequestId;
    private boolean showTags;

    public static String getDurationString(long duration) {
        long years = duration / (long)SECONDS_IN_YEAR;
        long months = duration % (long)SECONDS_IN_YEAR / (long)SECONDS_IN_MONTH;
        String durationString = "";
        if (years > 0L) {
            durationString = durationString + years + "y ";
        }
        if (months > 0L) {
            durationString = durationString + months + "m ";
        }
        return durationString;
    }

    public Outputter(boolean showHeaders, boolean showDebug, boolean showNullFields, boolean showRequestId, boolean showTags) {
        this.showHeaders = showHeaders;
        this.showDebug = showDebug;
        this.showNullFields = showNullFields;
        this.showRequestId = showRequestId;
        this.showTags = showTags;
    }

    public Outputter(boolean showHeaders, boolean showDebug, boolean showNullFields, boolean showRequestId) {
        this(showHeaders, showDebug, showNullFields, showRequestId, true);
    }

    private String toPaddedHexString(int v) {
        String s = Integer.toHexString(v);
        while (s.length() < 4) {
            s = '0' + s;
        }
        return s;
    }

    private String toDisplayState(String name, int code) {
        String stateName = name;
        if (this.showDebug) {
            stateName = stateName + "(" + this.toPaddedHexString(code) + ")";
        }
        return stateName;
    }

    private String toDisplayLicense(InstanceLicense license) {
        return null == license ? null : license.pool;
    }

    public void output(PrintStream stream, String productCode, String instanceId, boolean confirmed, String ownerId) {
        this.printHeaders(stream, "ProductCode", "InstanceID", "Confirmed", "OwnerID");
        stream.println(this.join(productCode, instanceId, Boolean.toString(confirmed), ownerId));
    }

    public void output(PrintStream stream, ReservationDescription.Instance inst) {
        String ali;
        this.printHeaders(stream, "Type", "InstanceID", "ImageID", "PublicDNSName", "PrivateDNSName", "State", "KeyPair", "AmiLaunchIndex", "ProductCodes", "InstanceType", "LaunchTime", "AvailabilityZone", "KernelId", "RamdiskId", "Monitoring", "PublicIpAddress", "PrivateIpAddress", "Vpc", "Subnet", "RootDeviceType", "InstanceLifecycle", "SpotInstanceRequestID", "LicensePool", "PlacementGroupName", "VirtualizationType", "Hypervisor", "Tenancy");
        String keyName = inst.keyName;
        if (keyName == null) {
            keyName = "";
        }
        if ((ali = inst.amiLaunchIndex) == null) {
            ali = "";
        }
        String groupString = "";
        for (String group : inst.groups) {
            groupString = groupString + ", " + group;
        }
        if (groupString.length() > 0) {
            groupString = groupString.substring(2);
        }
        stream.println(this.join("INSTANCE", inst.instanceId, inst.imageId, inst.dnsName, inst.privateDnsName, this.toDisplayState(inst.state, inst.stateCode), keyName, ali, this.joinCollection(inst.productCodes, ","), inst.instanceType, this.iso8601(inst.launchTime), inst.placement.availabilityZone, inst.kernelId, inst.ramdiskId, inst.platform, "monitoring-" + inst.monitoring.getState(), inst.publicIpAddress, inst.privateIpAddress, inst.vpcId, inst.subnetId, inst.rootDeviceType, inst.instanceLifecycle, inst.spotInstanceRequestId, this.toDisplayLicense(inst.license), inst.placement.groupName, inst.virtualizationType, inst.hypervisor, inst.clientToken, groupString, inst.placement.tenancy));
    }

    public String joinCollection(Collection<String> strs, String sep) {
        StringBuilder jstr = new StringBuilder();
        if (strs != null) {
            for (String str : strs) {
                if (jstr.length() != 0) {
                    jstr.append(sep);
                }
                jstr.append(str);
            }
        }
        return jstr.toString();
    }

    public String joinMap(Map<String, String> strs, String sep) {
        StringBuilder jstr = new StringBuilder();
        if (strs != null) {
            Set<String> keys = strs.keySet();
            Iterator<String> keyIterator = keys.iterator();
            while (keyIterator.hasNext()) {
                if (jstr.length() != 0) {
                    jstr.append(sep);
                }
                String key = keyIterator.next();
                String value = strs.get(key);
                jstr.append(key + "=" + (value != null ? value : "null"));
            }
        }
        return jstr.toString();
    }

    public void outputNetworkAclDescriptions(PrintStream stream, List<NetworkAclDescription> networkAclDescriptions) {
        for (NetworkAclDescription networkAclDescription : networkAclDescriptions) {
            this.output(stream, networkAclDescription);
        }
    }

    public void output(PrintStream stream, NetworkAclDescription response) {
        this.printHeaders(stream, "NetworkAclId", "VpcId", "Default");
        stream.println(this.join("NETWORKACL", response.networkAclId, response.vpcId, response.networkDefault != false ? "default" : ""));
        if (!response.entries.isEmpty()) {
            this.printHeaders(stream, "Rule", "Action", "CIDR", "Protocol", "Type", "Code", "From", "To");
            this.outputNetworkAclEntryDescriptions(stream, response.entries);
        }
        this.outputNetworkAclAssociationDescriptionsWithoutId(stream, response.associations);
        this.outputTags(stream, response.tags);
    }

    private void outputNetworkAclEntryDescriptions(PrintStream stream, List<NetworkAclEntryDescription> entries) {
        if (!entries.isEmpty()) {
            for (NetworkAclEntryDescription entry : entries) {
                this.outputNetworkAclEntryDescription(stream, entry);
            }
        }
    }

    private void outputNetworkAclEntryDescription(PrintStream stream, NetworkAclEntryDescription entry) {
        stream.println(this.join("ENTRY", entry.isEgress() ? "egress" : "ingress", entry.ruleNumber, entry.action, entry.cidr, entry.protocol, entry.icmpCode == null ? null : Integer.valueOf(entry.icmpCode.type), entry.icmpCode == null ? null : Integer.valueOf(entry.icmpCode.code), entry.portRange == null ? null : Integer.valueOf(entry.portRange.from), entry.portRange == null ? null : Integer.valueOf(entry.portRange.to)));
    }

    public void output(PrintStream stream, NetworkAclEntryDescription entry) {
        this.printHeaders(stream, "Rule", "Action", "CIDR", "Protocol", "Type", "Code", "From", "To");
        this.outputNetworkAclEntryDescription(stream, entry);
    }

    public void output(PrintStream stream, NetworkAclAssociationDescription response) {
        ArrayList<NetworkAclAssociationDescription> list = new ArrayList<NetworkAclAssociationDescription>();
        list.add(response);
        this.outputNetworkAclAssociationDescriptions(stream, list);
    }

    public void outputInstanceStatusDescriptions(PrintStream stream, List<InstanceStatusDescription> response) {
        Boolean showHeaders = this.showHeaders;
        this.printHeaders(stream, "Type", "InstanceId", "AvailabilityZone", "InstanceStateName", "InstanceStateCode");
        for (InstanceStatusDescription description : response) {
            stream.println(this.join("INSTANCE", description.instanceId, description.availabilityZone, description.instanceStateName, description.instanceStateCode));
            if (description.events.isEmpty()) continue;
            this.showHeaders = showHeaders;
            this.printHeaders(stream, "Type", "EventCode", "NotBefore", "NotAfter", "EventDescription");
            for (Event event : description.events) {
                stream.println(this.join("EVENT", event.getCode(), this.iso8601(event.getNotBefore()), event.getNotAfter() == null ? "" : this.iso8601(event.getNotAfter()), event.getDescription()));
            }
        }
    }

    private void outputNetworkAclAssociationDescriptions(PrintStream stream, List<NetworkAclAssociationDescription> associations) {
        this.printHeaders(stream, "NetworkAclAssociationId", "NetworkAclId", "SubnetId");
        for (NetworkAclAssociationDescription association : associations) {
            stream.println(this.join("ASSOCIATION", association.networkAclAssociationId, association.networkAclId, association.subnetId));
        }
    }

    private void outputNetworkAclAssociationDescriptionsWithoutId(PrintStream stream, List<NetworkAclAssociationDescription> associations) {
        this.printHeaders(stream, "NetworkAclAssociationId", "SubnetId");
        for (NetworkAclAssociationDescription association : associations) {
            stream.println(this.join("ASSOCIATION", association.networkAclAssociationId, association.subnetId));
        }
    }

    public void output(PrintStream stream, List<RouteTableDescription> routeTableDescriptions) {
        for (RouteTableDescription routeTableDescription : routeTableDescriptions) {
            this.output(stream, routeTableDescription);
        }
    }

    public void output(PrintStream stream, RouteTableAssociationDescription assoc) {
        ArrayList<RouteTableAssociationDescription> assocList = new ArrayList<RouteTableAssociationDescription>();
        assocList.add(assoc);
        this.outputRouteTableAssociationDescriptions(stream, assocList, true);
    }

    public void output(PrintStream stream, RouteDescription desc) {
        this.printHeaders(stream, "GatewayId", "InstanceId", "State", "CidrBlock");
        this.outputRouteDescription(stream, desc);
    }

    public void outputRouteDescriptions(PrintStream stream, List<RouteDescription> routeDescriptions) {
        this.printHeaders(stream, "GatewayId", "InstanceId", "State", "CidrBlock");
        for (RouteDescription routeDescription : routeDescriptions) {
            this.outputRouteDescription(stream, routeDescription);
        }
    }

    public void outputRouteDescription(PrintStream stream, RouteDescription routeDescription) {
        stream.println(this.join("ROUTE", routeDescription.gatewayId, routeDescription.instanceId, routeDescription.state, routeDescription.cidrBlock));
    }

    public void outputRouteTableAssociationDescriptions(PrintStream stream, List<RouteTableAssociationDescription> routeTableAssociationDescriptions, boolean printTableId) {
        if (printTableId) {
            this.printHeaders(stream, "AssociationId", "RouteTableId", "SourceSpec");
        } else {
            this.printHeaders(stream, "AssociationId", "SourceSpec");
        }
        for (RouteTableAssociationDescription routeTableAssociationDescription : routeTableAssociationDescriptions) {
            String sourceSpec = routeTableAssociationDescription.main != null && routeTableAssociationDescription.main == true ? "main" : routeTableAssociationDescription.subnetId;
            if (printTableId) {
                stream.println(this.join("ASSOCIATION", routeTableAssociationDescription.associationId, routeTableAssociationDescription.tableId, sourceSpec));
                continue;
            }
            stream.println(this.join("ASSOCIATION", routeTableAssociationDescription.associationId, sourceSpec));
        }
    }

    public void output(PrintStream stream, RouteTableDescription routeTableDescription) {
        this.printHeaders(stream, "RouteTableId", "VpcId");
        stream.println(this.join("ROUTETABLE", routeTableDescription.routeTableId, routeTableDescription.vpcId));
        this.outputRouteDescriptions(stream, routeTableDescription.routeDescriptions);
        this.outputRouteTableAssociationDescriptions(stream, routeTableDescription.routeTableAssociationDescriptions, false);
        this.outputTags(stream, routeTableDescription.tagDescriptions);
    }

    public void output(PrintStream stream, InternetGatewayDescription gatewayDescription) {
        this.printHeaders(stream, "InternetGatewayId");
        stream.println(this.join("INTERNETGATEWAY", gatewayDescription.internetGatewayId));
        if (gatewayDescription.attachmentDescriptions != null && !gatewayDescription.attachmentDescriptions.isEmpty()) {
            for (InternetGatewayAttachmentDescription attach : gatewayDescription.attachmentDescriptions) {
                this.output(stream, attach);
            }
        }
        this.outputTags(stream, gatewayDescription.tagDescriptions);
    }

    public void output(PrintStream stream, InternetGatewayAttachmentDescription description) {
        this.printHeaders(stream, "VpcID", "State");
        stream.println(this.join("ATTACHMENT", description.vpc, description.state));
    }

    public void outputTags(PrintStream stream, List<TagDescription> tags) {
        this.printHeaders(stream, "ResourceType", "ResourceId", "Key", "Value");
        for (TagDescription tag : tags) {
            stream.println(this.join("TAG", tag.resourceType, tag.resourceId, tag.key, tag.value));
        }
    }

    public void output(PrintStream stream, ReservationDescription res) {
        this.printHeaders(stream, "Type", "ReservationID", "Owner", "Groups", "Platform");
        StringBuffer groups = new StringBuffer();
        for (String i : res.groups) {
            groups.append(",");
            groups.append(i);
        }
        if (groups.length() > 0) {
            groups.deleteCharAt(0);
        }
        stream.println(this.join("RESERVATION", res.resId, res.owner, groups));
        for (String i : res.instances) {
            this.output(System.out, (ReservationDescription.Instance)i);
            if (((ReservationDescription.Instance)i).blockDevices != null && !((ReservationDescription.Instance)i).blockDevices.isEmpty()) {
                this.printHeaders(stream, "Type", "DeviceName", "Ephemeral", "VolumeId");
                for (InstanceBlockDeviceMappingResponseDescription blockDevice : ((ReservationDescription.Instance)i).blockDevices) {
                    this.outputBlockDeviceMapping(stream, blockDevice);
                }
            }
            this.outputResourceTags(stream, ((ReservationDescription.Instance)i).tags, ((ReservationDescription.Instance)i).instanceId, INSTANCE);
        }
    }

    public void output(PrintStream stream, License license) {
        this.printHeaders(stream, "LicenseID", "Type", "Pool");
        stream.println(this.join(license.licenseId, license.type, license.pool));
        for (LicenseCapacity capacity : license.capacityDetail) {
            this.printHeaders(stream, "State", "Capacity", "InstanceCapacity", "EarliestAllowedDeactivationTime");
            stream.println(this.join(capacity.state, capacity.capacity, capacity.instanceCapacity, null == capacity.earliestAllowedDeactivationTime ? null : this.iso8601(capacity.earliestAllowedDeactivationTime)));
        }
        this.outputResourceTags(stream, license.tags, license.licenseId, LICENSE);
    }

    public void output(PrintStream stream, DeactivateLicenseResponse response) {
        this.printHeaders(stream, "Result");
        stream.println(this.join(response._return));
    }

    public void output(PrintStream stream, ActivateLicenseResponse response) {
        this.printHeaders(stream, "Result");
        stream.println(this.join(response._return));
    }

    public void output(PrintStream stream, ImageDescription img) {
        this.printHeaders(stream, "Type", "ImageID", "Name", "Owner", "State", "Accessibility", "ProductCodes", "Architecture", "ImageType", "KernelId", "RamdiskId", "Platform", "RootDeviceType", "VirtualizationType", "Hypervisor");
        String owner = img.imageOwnerAlias != null ? img.imageOwnerAlias : img.imageOwnerId;
        String name = img.name != null ? owner + "/" + img.name : img.imageLocation;
        stream.println(this.join("IMAGE", img.imageId, name, owner, img.imageState, img.isPublic ? "public" : "private", this.joinCollection(img.productCodes, ","), img.architecture, img.imageType, img.kernelId, img.ramdiskId, img.platform, img.rootDeviceType, img.virtualizationType, img.hypervisor));
        if (img.blockDeviceMappings != null) {
            this.printHeaders(stream, "Type", "DeviceName", "Ephemeral", "SnapshotId", "VolumeSize");
            for (BlockDeviceMappingDescription blockDeviceMapping : img.blockDeviceMappings) {
                EbsSnapshotDescription ebs = blockDeviceMapping.getSnapshot();
                if (ebs == null) continue;
                stream.println(this.join("BLOCKDEVICEMAPPING", blockDeviceMapping.getDeviceName(), null, ebs.getSnapshotId(), ebs.getVolumeSize(), ebs.getDeleteOnTermination()));
            }
        }
        this.outputResourceTags(stream, img.tags, img.imageId, IMAGE);
    }

    public void outputImageId(PrintStream stream, String imageId) {
        this.printHeaders(stream, "Type", "ImageID");
        stream.println(this.join("IMAGE", imageId));
    }

    public void outputGroup(PrintStream stream, String name, String description) {
        this.printHeaders(stream, "Type", "Name", description);
        stream.println(this.join("GROUP", name, description));
    }

    public void outputGroup(PrintStream stream, String name, String description, String groupId) {
        this.printHeaders(stream, "Type", "Id", "Name", "Description");
        stream.println(this.join("GROUP", groupId, name, description));
    }

    public void outputGroup(PrintStream stream, String name) {
        this.printHeaders(stream, "Type", "Name");
        stream.println(this.join("GROUP", name));
    }

    public void output(PrintStream stream, InstanceStateChangeDescription inst) {
        this.printHeaders(stream, "Type", "Name");
        String prevState = this.toDisplayState(inst.prevState, inst.prevStateCode);
        String shutdownState = this.toDisplayState(inst.shutdownState, inst.shutdownStateCode);
        stream.println(this.join("INSTANCE", inst.instanceId, prevState, shutdownState));
    }

    public void output(PrintStream stream, boolean b) {
        stream.println(this.join("RETURN", b));
    }

    public void output(PrintStream stream, String s) {
        stream.println(s);
    }

    protected void output(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        if (!perm.cidrIps.isEmpty()) {
            for (String cidr : perm.cidrIps) {
                this.outputCIDRSource(stream, uid, groupName, perm);
                stream.println(this.join("", "CIDR", cidr));
            }
        }
        if (!perm.uid_group_pairs.isEmpty()) {
            for (UserIdGroupPair group : perm.uid_group_pairs) {
                this.outputGroupSource(stream, uid, groupName, perm);
                if (group.getGroupId() != null) {
                    stream.println(this.join("", "GRPID", group.getGroupId()));
                    continue;
                }
                stream.println(this.join("", "USER", group.getUserId(), "GRPNAME", group.getName()));
            }
        }
    }

    private void outputEntireGroupSource(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission p) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", "all", "", "", p.egress != false ? "TO" : "FROM"));
    }

    private void outputGroupSource(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", perm.protocol, perm.fromPort, perm.toPort, perm.egress != false ? "TO" : "FROM"));
    }

    private void outputCIDRSource(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", perm.protocol, perm.fromPort, perm.toPort, perm.egress != false ? "TO" : "FROM"));
    }

    public void output(PrintStream stream, SecurityGroupDescription grp) {
        int bitmap;
        String key;
        this.printHeaders(stream, "GROUP", "Id", "Owner", "Name", "Description", "VpcID");
        stream.println(this.join("GROUP", grp.id, grp.owner, grp.name, grp.desc, grp.vpcId));
        HashMap<String, Integer> permMap = new HashMap<String, Integer>();
        for (SecurityGroupDescription.IpPermission p : grp.perms) {
            for (UserIdGroupPair pair : p.uid_group_pairs) {
                key = pair.getUserId() + ":" + pair.getName();
                bitmap = 0;
                if (permMap.containsKey(key)) {
                    bitmap = (Integer)permMap.get(key);
                }
                if (new Integer(0).equals(p.fromPort) && new Integer(65535).equals(p.toPort)) {
                    bitmap = p.protocol.equalsIgnoreCase("tcp") ? (bitmap |= 1) : (bitmap |= 2);
                }
                if (new Integer(0).equals(p.fromPort) && new Integer(0).equals(p.toPort) && p.protocol.equalsIgnoreCase("icmp")) {
                    bitmap |= 4;
                }
                permMap.put(key, bitmap);
            }
        }
        for (SecurityGroupDescription.IpPermission p : grp.perms) {
            block7: for (UserIdGroupPair pair : p.uid_group_pairs) {
                key = pair.getUserId() + ":" + pair.getName();
                bitmap = (Integer)permMap.get(key);
                switch (bitmap) {
                    case -1: {
                        continue block7;
                    }
                    case 7: {
                        this.outputEntireGroupSource(stream, grp.owner, grp.name, p);
                        stream.println(this.join("", "USER", pair.getUserId(), pair.getName() == null ? "" : "NAME " + pair.getName(), pair.getGroupId() == null ? "" : "ID " + pair.getGroupId(), p.egress != false ? "egress" : "ingress"));
                        permMap.put(key, -1);
                        continue block7;
                    }
                }
                this.outputGroupSource(stream, grp.owner, grp.name, p);
                stream.println(this.join("", "USER", pair.getUserId(), pair.getName() == null ? "" : "NAME " + pair.getName(), pair.getGroupId() == null ? "" : "ID " + pair.getGroupId(), p.egress != false ? "egress" : "ingress"));
            }
            if (p.cidrIps.isEmpty()) continue;
            for (String cidr : p.cidrIps) {
                this.outputCIDRSource(stream, grp.owner, grp.name, p);
                stream.println(this.join("", "CIDR", cidr, p.egress != false ? "egress" : "ingress"));
            }
        }
        this.outputResourceTags(stream, grp.tags, grp.id, "GROUP");
    }

    public void output(PrintStream stream, AvailabilityZoneDescription zone) {
        this.printHeaders(stream, "AVAILABILITYZONE", "Name", "State", "Region", "Messages");
        StringBuilder messages = new StringBuilder();
        if (zone.messages != null) {
            boolean first = true;
            for (String message : zone.messages) {
                if (first) {
                    first = false;
                } else {
                    messages.append("; ");
                }
                messages.append(message);
            }
        }
        stream.println(this.join("AVAILABILITYZONE", zone.name, zone.state, zone.region, messages));
    }

    public void output(PrintStream stream, RegionDescription region) {
        this.printHeaders(stream, "REGION", "Name", "Endpoint");
        stream.println(this.join("REGION", region.name, region.endpoint));
    }

    public void outputAttachment(PrintStream stream, String volumeId) {
        this.printHeaders(stream, "Type", "VolumeId");
        stream.println(this.join("ATTACHMENT", volumeId));
    }

    public void output(PrintStream stream, AttachmentDescription ad) {
        this.printHeaders(stream, "VolumeId", "InstanceId", "Device", "Status", "AttachTime");
        stream.println(this.join("ATTACHMENT", ad.volumeId, ad.instanceId, ad.device, ad.status, ad.attachTime == null ? "" : this.iso8601(ad.attachTime)));
    }

    public void outputVolume(PrintStream stream, String volumeId) {
        this.printHeaders(stream, "Type", "VolumeId");
        stream.println(this.join("VOLUME", volumeId));
    }

    public void output(PrintStream stream, VolumeDescription vd) {
        this.printHeaders(stream, "VolumeId", "Size", "SnapshotId", "AvailabilityZone", "Status", "CreateTime", "ComittedIops");
        stream.println(this.join("VOLUME", vd.volumeId, vd.size, vd.snapshotId, vd.availabilityZone, vd.status, this.iso8601(vd.createTime)));
        if (vd.attachments != null && !vd.attachments.isEmpty()) {
            for (AttachmentDescription ad : vd.attachments) {
                this.output(stream, ad);
            }
        }
        this.outputResourceTags(stream, vd.tags, vd.volumeId, VOLUME);
    }

    public void outputResourceTags(PrintStream stream, List<ResourceTagDescription> tags, String resourceId, String resourceType) {
        if (this.showTags && tags != null && !tags.isEmpty()) {
            for (ResourceTagDescription tag : tags) {
                this.outputResourceTag(stream, tag, resourceId, resourceType);
            }
        }
    }

    public void outputReservedInstanceOfferings(PrintStream stream, List<ReservedInstancesOfferingDescription> riods) {
        Boolean showHeaders = this.showHeaders;
        this.printHeaders(stream, "Type", "ReservedInstancesOfferingId", "AvailabilityZone", "InstanceType", "Duration", "FixedPrice", "UsagePrice", "ProductDescription", "Currency", "InstanceTenancy", "OfferingType");
        for (ReservedInstancesOfferingDescription riod : riods) {
            stream.println(this.join("OFFERING", riod.reservedInstancesOfferingId, riod.availabilityZone, riod.instanceType, Outputter.getDurationString(riod.duration), riod.fixedPrice, riod.usagePrice, riod.productDescription, riod.currencyCode, riod.instanceTenancy, riod.offeringType));
            this.outputRecurringCharges(stream, showHeaders, riod.recurringCharges);
        }
    }

    public void outputReservedInstances(PrintStream stream, List<ReservedInstancesDescription> rids) {
        Boolean showHeaders = this.showHeaders;
        this.printHeaders(stream, "Type", "ReservedInstancesId", "AvailabilityZone", "InstanceType", "ProductDescription", "Duration", "FixedPrice", "UsagePrice", "InstanceCount", "Start", "State", "Currency", "InstanceTenancy", "OfferingType");
        for (ReservedInstancesDescription rid : rids) {
            stream.println(this.join("RESERVEDINSTANCES", rid.reservedInstancesId, rid.availabilityZone, rid.instanceType, rid.productDescription, Outputter.getDurationString(rid.duration), rid.fixedPrice, rid.usagePrice, rid.instanceCount, this.iso8601(rid.start), rid.state, rid.currencyCode, rid.instanceTenancy, rid.offeringType));
            this.outputRecurringCharges(stream, showHeaders, rid.recurringCharges);
            this.outputResourceTags(stream, rid.tags, rid.reservedInstancesId, RESERVED_INSTANCES);
        }
    }

    private void outputRecurringCharges(PrintStream stream, Boolean showHeaders, List<RecurringCharge> recurringCharges) {
        if (recurringCharges.size() > 0) {
            this.showHeaders = showHeaders;
            this.printHeaders(stream, "Type", "Frequency", "Amount");
            for (RecurringCharge charge : recurringCharges) {
                stream.println(this.join("RECURRING-CHARGE", charge.getFrequency(), charge.getAmount()));
            }
        }
    }

    public void outputReservedInstancesId(PrintStream stream, String reservedInstancesId) {
        this.printHeaders(stream, "Type", "ReservedInstancesId");
        stream.println(this.join("RESERVEDINSTANCES", reservedInstancesId));
    }

    public void outputSnapshot(PrintStream stream, String snapshotId) {
        this.printHeaders(stream, "Type", "SnapshotId");
        stream.println(this.join("SNAPSHOT", snapshotId));
    }

    public void output(PrintStream stream, SnapshotDescription sd) {
        this.printHeaders(stream, "SnapshotId", "VolumeId", "Status", "StartTime", "Progress", "OwnerId", "VolumeSize", "Description");
        stream.println(this.join("SNAPSHOT", sd.snapshotId, sd.volumeId, sd.status, this.iso8601(sd.startTime), sd.progress, sd.ownerId, sd.volumeSize, sd.description));
        this.outputResourceTags(stream, sd.tags, sd.snapshotId, SNAPSHOT);
    }

    public void output(PrintStream stream, String snapshotId, SnapshotAttribute attribute) {
        this.printHeaders(stream, "Attribute", "SnapshotID", "ItemType", "ItemValue");
        if (attribute instanceof SnapshotListAttribute) {
            SnapshotListAttribute listAttribute = (SnapshotListAttribute)attribute;
            for (SnapshotListAttributeItem item : listAttribute.items) {
                stream.println(this.join(attribute.type.name(), snapshotId, item.type.name(), item.value));
            }
        }
    }

    public void output(PrintStream stream, String snapshotId, SnapshotAttribute attribute, SnapshotListAttribute.SnapshotListAttributeOperationType operation) {
        this.printHeaders(stream, "Attribute", "SnapshotID", "Operation", "ItemType", "ItemValue");
        if (attribute instanceof SnapshotListAttribute) {
            SnapshotListAttribute listAttribute = (SnapshotListAttribute)attribute;
            for (SnapshotListAttributeItem item : listAttribute.items) {
                String operationName = operation != null ? operation.name().toUpperCase() : "";
                stream.println(this.join(attribute.type.name(), snapshotId, operationName, item.type.name(), item.value));
            }
        }
    }

    public void output(PrintStream stream, String imageId, SnapshotAttribute.SnapshotAttributeType attributeType) {
        this.printHeaders(stream, "Attribute", "SnapshotID", "Operation");
        stream.println(this.join(attributeType.name(), imageId, "RESET"));
    }

    public void output(PrintStream stream, String imageId, ImageAttribute attribute) {
        this.printHeaders(stream, "Attribute", "ImageID", "ItemType", "ItemValue");
        if (attribute instanceof ImageMapAttribute) {
            ImageMapAttribute mapAttribute = (ImageMapAttribute)attribute;
            for (ImageMapAttributeItem item : mapAttribute.items) {
                stream.println(this.join(attribute.type.name(), imageId, item.type.name(), item.key + ": " + item.value));
            }
        } else if (attribute instanceof ImageListAttribute) {
            ImageListAttribute listAttribute = (ImageListAttribute)attribute;
            for (ImageListAttributeItem item : listAttribute.items) {
                stream.println(this.join(attribute.type.name(), imageId, item.type.name(), item.value));
            }
        } else if (attribute instanceof ImageValueAttribute) {
            ImageValueAttribute valueAttribute = (ImageValueAttribute)attribute;
            if (valueAttribute.value != null) {
                stream.println(this.join(attribute.type.name(), imageId, "", valueAttribute.value));
            }
        }
    }

    public void outputBlockDeviceMapping(PrintStream stream, InstanceBlockDeviceMappingResponseDescription blockDevice) {
        EbsVolumeDescription ebs = blockDevice.getEbs();
        if (ebs != null) {
            stream.println(this.join("BLOCKDEVICE", blockDevice.getDeviceName(), ebs.getVolumeId(), ebs.getAttachmentTime(), ebs.getDeleteOnTermination()));
        } else {
            stream.println(this.join("BLOCKDEVICE", blockDevice.getDeviceName(), null, null, null));
        }
    }

    public void outputBlockDeviceMappings(PrintStream stream, List<Object> blockDevices) {
        for (int i = 0; i < blockDevices.size(); ++i) {
            InstanceBlockDeviceMappingResponseDescription blockDevice;
            EbsVolumeDescription ebs = null;
            String deviceName = new String();
            if (blockDevices.get(i) instanceof InstanceBlockDeviceMappingResponseDescription) {
                blockDevice = (InstanceBlockDeviceMappingResponseDescription)blockDevices.get(i);
                ebs = blockDevice.getEbs();
                deviceName = blockDevice.getDeviceName();
            } else if (blockDevices.get(i) instanceof InstanceBlockDeviceMappingDescription) {
                blockDevice = (InstanceBlockDeviceMappingDescription)blockDevices.get(i);
                ebs = blockDevice.getVolume();
                deviceName = blockDevice.getDeviceName();
            }
            if (ebs != null) {
                stream.println(this.join("BLOCKDEVICE", deviceName, ebs.getVolumeId(), ebs.getAttachmentTime(), ebs.getDeleteOnTermination()));
                continue;
            }
            stream.println(this.join("BLOCKDEVICE", deviceName, null, null, null));
        }
    }

    public void outputInstanceAttribute(PrintStream stream, String instanceId, InstanceAttribute<?> instanceAttribute) {
        this.printHeaders(stream, "Attribute", "InstanceID", "ItemValue");
        if (instanceAttribute.getValue() == null) {
            stream.println(this.join(instanceAttribute.getType().name(), instanceId, null));
        } else if (instanceAttribute.getValue() instanceof String) {
            String value = (String)instanceAttribute.getValue();
            if (InstanceAttribute.InstanceAttributeType.userData.equals((Object)instanceAttribute.getType())) {
                try {
                    value = new String(new BASE64Decoder().decodeBuffer(value));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            stream.println(this.join(instanceAttribute.getType().name(), instanceId, value));
        } else if (instanceAttribute.getValue() instanceof Boolean) {
            Boolean value = (Boolean)instanceAttribute.getValue();
            stream.println(this.join(instanceAttribute.getType().name(), instanceId, value));
        } else if (instanceAttribute.getType() == InstanceAttribute.InstanceAttributeType.blockDeviceMapping) {
            this.outputBlockDeviceMappings(stream, (List)instanceAttribute.getValue());
        } else if (instanceAttribute.getType() == InstanceAttribute.InstanceAttributeType.groupSet) {
            String groups = "";
            try {
                String[] groupSet;
                for (String val : groupSet = (String[])instanceAttribute.getValue()) {
                    groups = groups + ", " + val;
                }
                if (groups.length() > 0) {
                    groups = groups.substring(2);
                }
            }
            catch (ClassCastException e) {
                try {
                    groups = (String)instanceAttribute.getValue();
                }
                catch (ClassCastException e2) {
                    // empty catch block
                }
            }
            stream.println(this.join(instanceAttribute.getType().name(), instanceId, groups));
        }
    }

    public void output(PrintStream stream, String imageId, ImageAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operation) {
        this.printHeaders(stream, "Attribute", "ImageID", "Operation", "ItemType", "ItemValue");
        if (attribute instanceof ImageMapAttribute) {
            ImageMapAttribute mapAttribute = (ImageMapAttribute)attribute;
            for (ImageMapAttributeItem item : mapAttribute.items) {
                String operationName = operation != null ? operation.name().toUpperCase() : "SET";
                stream.println(this.join(attribute.type.name(), imageId, operationName, item.type.name(), item.key + ": " + item.value));
            }
        } else if (attribute instanceof ImageListAttribute) {
            ImageListAttribute listAttribute = (ImageListAttribute)attribute;
            for (ImageListAttributeItem item : listAttribute.items) {
                String operationName = operation != null ? operation.name().toUpperCase() : "";
                stream.println(this.join(attribute.type.name(), imageId, operationName, item.type.name(), item.value));
            }
        } else if (attribute instanceof ImageValueAttribute) {
            ImageValueAttribute valueAttribute = (ImageValueAttribute)attribute;
            stream.println(this.join(attribute.type.name(), imageId, "SET", "", valueAttribute.value != null ? valueAttribute.value : ""));
        }
    }

    public void output(PrintStream stream, String imageId, ImageAttribute.ImageAttributeType attributeType) {
        this.printHeaders(stream, "Attribute", "ImageID", "Operation");
        stream.println(this.join(attributeType.name(), imageId, "RESET"));
    }

    public void output(PrintStream stream, String instanceId, InstanceAttribute.InstanceAttributeType attributeType) {
        this.printHeaders(stream, "Attribute", "InstanceID", "Operation");
        stream.println(this.join(attributeType.name(), instanceId, "RESET"));
    }

    public void output(PrintStream stream, MonitorInstance inst) {
        this.printHeaders(stream, "InstanceId", "State");
        stream.println(this.join(inst.getInstanceId(), "monitoring-" + inst.getMonitoring().getState()));
    }

    public void output(PrintStream stream, VpcDescription vpc) {
        this.printHeaders(stream, "Entity", "VpcID", "State", "CIDR Block", "DHCPOptionsID");
        stream.println(this.join("VPC", vpc.getVpcId(), vpc.getState(), vpc.getCidrBlock(), vpc.getDhcpOptionsId(), vpc.getInstanceTenancy()));
        this.outputResourceTags(stream, vpc.getTags(), vpc.getVpcId(), VPC);
    }

    public void output(PrintStream stream, SubnetDescription subnet) {
        this.printHeaders(stream, "Entity", "SubnetID", "State", "VpcID", "CIDR Block", "FreeAddressCount", "AvailabilityZone");
        stream.println(this.join("SUBNET", subnet.getSubnetId(), subnet.getState(), subnet.getVpcId(), subnet.getCidrBlock(), subnet.getFreeAddressCount(), subnet.getAvailabilityZone()));
        this.outputResourceTags(stream, subnet.getTags(), subnet.getSubnetId(), SUBNET);
    }

    public void output(PrintStream stream, CustomerGatewayDescription cgw) {
        this.printHeaders(stream, "Entity", "CustomerGatewayId", "State", "Type", "IPAddress", "BgpAsn");
        stream.println(this.join("CUSTOMERGATEWAY", cgw.getCustomerGatewayId(), cgw.getState(), cgw.getType(), cgw.getIpAddress(), cgw.getBgpAsn()));
        this.outputResourceTags(stream, cgw.getTags(), cgw.getCustomerGatewayId(), CUSTOMER_GATEWAY);
    }

    public void output(PrintStream stream, VpnGatewayDescription vgw) {
        this.printHeaders(stream, "Entity", "VpnGatewayId", "State", "Type", "AvailabilityZone");
        stream.println(this.join("VPNGATEWAY", vgw.getVpnGatewayId(), vgw.getState(), vgw.getType(), vgw.getAvailabilityZone()));
        this.outputResourceTags(stream, vgw.getTags(), vgw.getVpnGatewayId(), VPN_GATEWAY);
    }

    public void output(PrintStream stream, VpnGatewayAttachmentDescription attachment) {
        this.printHeaders(stream, "Entity", "VpcID", "State");
        stream.println(this.join("VGWATTACHMENT", attachment.getVpcId(), attachment.getState()));
    }

    public void output(PrintStream stream, VpnConnectionDescription vpnConnection) {
        this.printHeaders(stream, "Entity", "VpnConnectionID", "State", "Type", "CustomerGatewayID", "VpnGatewayID");
        stream.println(this.join("VPNCONNECTION", vpnConnection.getVpnConnectionId(), vpnConnection.getState(), vpnConnection.getType(), vpnConnection.getCustomerGatewayId(), vpnConnection.getVpnGatewayId()));
        this.outputResourceTags(stream, vpnConnection.getTags(), vpnConnection.getVpnConnectionId(), VPN_CONNECTION);
    }

    public void output(PrintStream stream, VgwTelemetryDescription vgwTelemetry) {
        this.printHeaders(stream, "Address", "Status", "LastStatusChange", "StatusMessage", "NumAcceptedRoutes");
        stream.println(this.join("TUNNEL", vgwTelemetry.getOutsideIpAddress(), vgwTelemetry.getStatus(), vgwTelemetry.getLastStatusChange(), vgwTelemetry.getStatusMessage(), vgwTelemetry.getAcceptedRouteCount()));
    }

    public void output(PrintStream stream, DhcpOptionsDescription dhcp) {
        this.printHeaders(stream, "Entity", "DHCPOptionsId");
        stream.println(this.join("DHCPOPTIONS", dhcp.getDhcpOptionsId()));
        if (dhcp.getDhcpConfiguration() != null) {
            for (Map.Entry entry : dhcp.getDhcpConfiguration().entrySet()) {
                StringBuilder valueStringBuilder = new StringBuilder();
                boolean first = true;
                for (String value : (List)entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        valueStringBuilder.append(",");
                    }
                    valueStringBuilder.append(value);
                }
                stream.println(this.join("OPTION", entry.getKey(), valueStringBuilder.toString()));
            }
        }
        this.outputResourceTags(stream, dhcp.getTags(), dhcp.getDhcpOptionsId(), DHCP_OPTIONS);
    }

    public void output(PrintStream stream, SpotInstanceRequestDescription req) {
        this.printHeaders(stream, "Type", "SpotInstanceRequestID", "Price", "RequestType", "ProductDescription", "State", "Created", "ValidFrom", "ValidUntil", "LaunchGroup", "AZGroup", "InstanceID", "ImageID", "InstanceType", "KeyName", "Groups", "AvailabilityZone", "KernelID", "RamdiskID", "Monitored", "SubnetID", "LaunchedAvailabilityZone");
        String imageId = null;
        String keyName = null;
        String instanceType = null;
        String availabilityZone = null;
        String kernelId = null;
        String ramdiskId = null;
        Boolean monitoring = null;
        Map blockDeviceMappings = null;
        List groupIds = null;
        String addressingType = null;
        String subnetId = null;
        if (req.runSpotInstancesArgs != null) {
            imageId = req.runSpotInstancesArgs.imageId;
            keyName = req.runSpotInstancesArgs.keyName;
            instanceType = req.runSpotInstancesArgs.instanceType;
            availabilityZone = req.runSpotInstancesArgs.availabilityZone;
            kernelId = req.runSpotInstancesArgs.kernelId;
            ramdiskId = req.runSpotInstancesArgs.ramdiskId;
            monitoring = req.runSpotInstancesArgs.monitoring.enabled;
            blockDeviceMappings = req.runSpotInstancesArgs.blockDeviceMapping.mappings;
            groupIds = req.runSpotInstancesArgs.groupSet.groupIds;
            addressingType = req.runSpotInstancesArgs.addressingType;
            subnetId = req.runSpotInstancesArgs.subnetId;
        }
        stream.println(this.join("SPOTINSTANCEREQUEST", req.spotInstanceRequestId, req.price, req.type, req.productDescription, req.state, this.iso8601(req.createTime, TimeZone.getTimeZone("UTC")), this.iso8601(req.validUntil, TimeZone.getTimeZone("UTC")), this.iso8601(req.holdUntil, TimeZone.getTimeZone("UTC")), req.launchGroup, req.availabilityZoneGroup, req.instanceId, imageId, instanceType, keyName, this.joinCollection(groupIds, ","), availabilityZone, kernelId, ramdiskId, monitoring != false ? "monitoring-enabled" : "monitoring-disabled", subnetId, req.launchedAvailabilityZone));
        if (req.faultCode != null || req.faultMessage != null) {
            this.printHeaders(stream, "Type", "Code", "Message");
            stream.println(this.join("SPOTINSTANCEFAULT", req.faultCode, req.faultMessage));
        }
        this.outputResourceTags(stream, req.tags, req.spotInstanceRequestId, SPOT_INSTANCE_REQUEST);
    }

    public void output(PrintStream stream, CancelSpotInstanceRequestDescription desc) {
        this.printHeaders(stream, "Type", "SpotInstanceRequestID", "State");
        stream.println(this.join("SPOTINSTANCEREQUEST", desc.getSpotInstanceRequestId(), desc.getState()));
    }

    public void output(PrintStream stream, SpotPriceHistoryDescription req) {
        this.printHeaders(stream, "Type", "Price", "Timestamp", "InstanceType", "ProductDescription", "AvailabilityZone");
        stream.println(this.join("SPOTINSTANCEPRICE", req.price, this.iso8601(req.timestamp, TimeZone.getTimeZone("UTC")), req.instanceType, req.productDescription, req.availabilityZone));
    }

    public void outputConsoleOutput(PrintStream stream, ConsoleOutput co, boolean rawOutput) {
        stream.println(co.instanceId);
        stream.println(this.iso8601(co.timestamp));
        stream.println(rawOutput ? new String(co.output) : this.escapeConsoleOutput(co.output));
    }

    public String iso8601(Date date) {
        return this.iso8601(date, null);
    }

    public String iso8601(Date date, TimeZone fromTZ) {
        if (date == null) {
            return null;
        }
        Calendar cal = null;
        cal = fromTZ != null ? Calendar.getInstance(fromTZ) : Calendar.getInstance();
        cal.setTime(date);
        if (fromTZ != null) {
            cal.setTimeZone(TimeZone.getDefault());
        }
        Formatter fmt = new Formatter(Locale.US);
        fmt.format("%1$tFT%1$tH:%1$tM:%1$tS%1$tz", cal);
        return fmt.toString();
    }

    public String iso8601(Calendar cal) {
        Formatter fmt = new Formatter(Locale.US);
        fmt.format("%1$tFT%1$tH:%1$tM:%1$tS%1$tz", cal);
        return fmt.toString();
    }

    public String escapeConsoleOutput(String output) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        char prev = '\u0000';
        int len = output.length();
        for (int i = 0; i < len; ++i) {
            char c = output.charAt(i);
            if (c != '\u001b' && (c != '\n' || prev != '\n')) {
                sb.append(c != '\n' ? new Character(c).toString() : lineSep);
            }
            prev = c;
        }
        return sb.toString();
    }

    public void outputKeyPair(PrintStream stream, String keyName, String keyFP) {
        this.outputKeyPair(stream, keyName, keyFP, null);
    }

    public void outputKeyPair(PrintStream stream, String keyName, String keyFP, String keyMaterial) {
        this.printHeaders(stream, "KeyPair", "Fingerprint");
        stream.println(this.join("KEYPAIR", keyName, keyFP));
        if (keyMaterial != null) {
            stream.println(keyMaterial);
        }
    }

    public void output(PrintStream stream, SpotDatafeedSubscription sds) {
        this.printHeaders(stream, "Type", "Owner", "Bucket", "Prefix", "State");
        stream.println(this.join("SPOTDATAFEEDSUBSCRIPTION", sds.ownerId, sds.bucket, sds.prefix, sds.state));
    }

    public void outputKeyID(PrintStream stream, String keyName) {
        this.printHeaders(stream, "KeyPair");
        stream.println(this.join("KEYPAIR", keyName));
    }

    public void output(PrintStream stream, BundleInstanceTask task) {
        this.printHeaders(stream, "Type", "Bundle", "Instance", "Bucket", "Prefix", "StartTime", "UpdateTime", "State");
        stream.println(this.join("BUNDLE", task.bundleId, task.instanceId, task.bucket, task.prefix, this.iso8601(task.startTime), this.iso8601(task.updateTime), task.state, task.progress, task.errorCode, task.errorMessage));
    }

    public void outputAddress(PrintStream stream, String publicIp, String instanceId, String domain, String allocationId, String associationId) {
        this.printHeaders(stream, "Type", "Address", "Instance", "Domain", "AllocationId", "AssociationId");
        stream.println(this.join("ADDRESS", publicIp, instanceId, domain, allocationId, associationId));
    }

    public void outputAddressAssociation(PrintStream stream, String publicIp, String instanceId, String allocationId, String associationId) {
        this.printHeaders(stream, "Type", "Address", "Instance", "AllocationId", "AssociationId");
        stream.println(this.join("ADDRESS", publicIp, instanceId, allocationId, associationId));
    }

    public void outputAssociateDhcpWithVpc(PrintStream stream, String vpcId, String dhcpOptionId) {
        stream.println(this.join("DHCPOPTIONS", dhcpOptionId, vpcId));
    }

    public void outputPlacementGroup(PrintStream stream, String groupName, String strategy, String state) {
        this.printHeaders(stream, "Type", "Name", "Strategy", "State");
        stream.println(this.join("PLACEMENTGROUP", groupName, strategy, state));
    }

    public void outputPlacementGroup(PrintStream stream, String groupName, String state) {
        this.printHeaders(stream, "Type", "Name", "State");
        stream.println(this.join("PLACEMENTGROUP", groupName, state));
    }

    public void outputTag(PrintStream stream, TagDescription tag) {
        this.printHeaders(stream, "ResourceType", "ResourceId", "Key", "Value");
        stream.println(this.join("TAG", tag.resourceType, tag.resourceId, tag.key, tag.value));
    }

    public void outputResourceTag(PrintStream stream, ResourceTagDescription tag, String resourceId, String resourceType) {
        stream.println(this.join("TAG", resourceType, resourceId, tag.key, tag.value));
    }

    public List<Object> getConversionTaskDescription(ConversionTaskDescription task) {
        LinkedList<Object> fields = new LinkedList<Object>();
        fields.add("TaskType");
        fields.add(task.getTaskType().toUpperCase());
        fields.add("TaskId");
        fields.add(task.getTaskId());
        fields.add("ExpirationTime");
        fields.add(task.getExpirationTime());
        fields.add("Status");
        fields.add(task.getStatus());
        if (task.getStatusMessage() != null) {
            fields.add("StatusMessage");
            fields.add(task.getStatusMessage());
        }
        return fields;
    }

    public List<Object> getConversionDiskImageDescription(ImportVolumeConversionTask iv, boolean printTransferDetails) {
        LinkedList<Object> fields = new LinkedList<Object>();
        fields.add("DISKIMAGE");
        fields.add("DiskImageFormat");
        fields.add(iv.getDiskImageFormat());
        fields.add("DiskImageSize");
        fields.add(iv.getDiskImageSize());
        if (iv.getVolumeId() != null) {
            fields.add("VolumeId");
            fields.add(iv.getVolumeId());
        }
        fields.add("VolumeSize");
        fields.add(iv.getVolumeSize());
        fields.add("AvailabilityZone");
        fields.add(iv.getAvailabilityZone());
        if (printTransferDetails) {
            fields.add("ImportManifestUrl");
            fields.add(iv.getImportManifestUrl());
        }
        fields.add("ApproximateBytesConverted");
        fields.add(iv.getApproximateBytesConverted());
        if (iv.getComment() != null) {
            fields.add("Description");
            fields.add(iv.getComment());
        }
        return fields;
    }

    public void output(PrintStream stream, ConversionTaskDescription task, ImportVolumeConversionTask iv, boolean printTransferDetails) {
        List<Object> task_fields = this.getConversionTaskDescription(task);
        stream.println(this.join(task_fields.toArray()));
        List<Object> iv_fields = this.getConversionDiskImageDescription(iv, printTransferDetails);
        stream.println(this.join(iv_fields.toArray()));
    }

    public void output(PrintStream stream, ConversionTaskDescription task, ImportInstanceConversionTask ii, boolean printTransferDetails) {
        List<Object> fields = this.getConversionTaskDescription(task);
        fields.add("InstanceID");
        fields.add(ii.getInstanceID());
        if (ii.getComment() != null) {
            fields.add("Description");
            fields.add(ii.getComment());
        }
        stream.println(this.join(fields.toArray()));
        for (ImportInstanceVolumeDetail iv : ii.getVolumes()) {
            String status = iv.getStatus();
            String message = iv.getStatusMessage();
            List<Object> iv_fields = this.getConversionDiskImageDescription((ImportVolumeConversionTask)iv, printTransferDetails);
            iv_fields.add("Status");
            iv_fields.add(status);
            if (message != null) {
                iv_fields.add("StatusMessage");
                iv_fields.add(message);
            }
            stream.println(this.join(iv_fields.toArray()));
        }
    }

    public void outputConversionTask(PrintStream stream, String taskId) {
        stream.println(this.join("CONVERSION-TASK", taskId));
    }

    public void printRequestId(PrintStream stream, RequestResult result) {
        this.printRequestId(stream, result.getRequestId());
    }

    public void printRequestId(PrintStream stream, String requestId) {
        if (requestId != null && this.showRequestId) {
            stream.println(this.join("REQUEST ID", requestId));
        }
    }

    public void outputObjectId(PrintStream stream, String objectName, String id) {
        stream.println(this.join(objectName, id));
    }

    private void printHeaders(PrintStream stream, Object ... values) {
        if (this.showHeaders) {
            stream.println(this.join(values));
            this.showHeaders = false;
        }
    }

    private String join(Object ... values) {
        StringBuffer sb = new StringBuffer(this.stringValue(values[0]));
        for (int i = 1; i < values.length; ++i) {
            sb.append(FIELDSEP);
            sb.append(this.stringValue(values[i]));
        }
        return sb.toString();
    }

    private String stringValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            if (this.showNullFields) {
                return NULLFIELD;
            }
            return EMPTY_STRING;
        }
        return value.toString();
    }
}

