/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DisassociateAddress
extends BaseCmd {
    public DisassociateAddress(String[] args) {
        super("ec2disaddr", "ec2-disassociate-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"association-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"The ASSOCIATION_ID to use for the operation, used for VPC associations");
        result.addOption(OptionBuilder.create((String)"a"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "{ IP | -a ASSOCIATION_ID }";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Disassociate an elastic IP address from an instance.");
        System.out.println("     The IP parameter specifies the address to disassociate (non-VPC instances).");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("association-id");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String publicIp = null;
        String associationId = null;
        if (this.isOptionSet("association-id")) {
            if (this.getNonOptions().length > 0) {
                throw new InvalidArgumentCombination("Specify either IP (non-VPC) or -a allocation-id (VPC), not both.");
            }
            associationId = this.getOptionValue("association-id");
        } else {
            this.assertNonOptionSet("IP");
            publicIp = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
        }
        RequestResultPair rsp = jec2.disassociateAddress(publicIp, associationId);
        out.outputAddressAssociation(System.out, publicIp, null, null, associationId);
        out.printRequestId(System.out, rsp.getRequestId());
        return true;
    }

    public static void main(String[] args) {
        new DisassociateAddress(args).invoke();
    }
}

