/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ReleaseAddress
extends BaseCmd {
    public ReleaseAddress(String[] args) {
        super("ec2reladdr", "ec2-release-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"allocation-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ReleaseAddress.joinDescription(ALLOCATION_ID_DESC));
        result.addOption(OptionBuilder.create((String)"a"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "IP -a ALLOCATION_ID";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Release an allocated elastic IP address.");
        System.out.println("     The IP parameter specifies the address to release.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
        this.printOption("allocation-id");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String publicIp = null;
        String allocationId = null;
        if (this.isOptionSet("allocation-id")) {
            allocationId = this.getOptionValue("allocation-id");
        } else {
            this.assertNonOptionSet("IP");
            publicIp = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
        }
        RequestResultPair rsp = jec2.releaseAddress(publicIp, allocationId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputAddress(System.out, publicIp, null, null, allocationId, null);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public static void main(String[] args) {
        new ReleaseAddress(args).invoke();
    }
}

