/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.util.OsPipe;
import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.InvalidCertException;
import com.amazon.aes.webservices.client.InvalidKeyException;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.Jec2Impl;
import com.amazon.aes.webservices.client.Jec2SoapFaultException;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.InvalidRange;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.OnlyOneArgumentExpected;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.ShowVersion;
import com.amazon.aes.webservices.client.cmd.UnexpectedArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.EC2PosixParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import sun.misc.BASE64Encoder;

public abstract class BaseCmd {
    private static final String HIDE_TAGS_DESC = "Do not display tags for tagged resources.";
    private static final String HIDE_TAGS = "hide-tags";
    private static final String TIMEOUT_ARG = "TIMEOUT";
    private static final String KEY_ARG = "KEY";
    private static final String URL_ARG = "URL";
    private static final String CERT_ARG = "CERT";
    private static final String[] CERT_DESC = new String[]{"Specify CERT as the X509 certificate to use. Defaults to the value ", "of the EC2_CERT environment variable (if set). Overrides the default."};
    private static final String[] PRIVATE_KEY_DESC = new String[]{"Specify KEY as the private key to use. Defaults to the value of the", "EC2_PRIVATE_KEY environment variable (if set). Overrides the default."};
    private static final String REQUEST_TIMEOUT_DESC = "Specify a request timeout TIMEOUT (in seconds).";
    private static final String CONNECTION_TIMEOUT_DESC = "Specify a connection timeout TIMEOUT (in seconds).";
    private static final String SHOW_NULL_FIELDS_DESC = "Indicate empty fields.";
    private static final String DEBUG_DESC = "Display additional debugging information.";
    private static final String HEADERS_DESC = "Display column headers.";
    private static final String HELP_DESC = "Display this help.";
    private static final String VERBOSE_DESC = "Verbose output.";
    public static final String SPECIFIC_OPTIONS = "SPECIFIC OPTIONS";
    public static final String GENERAL_OPTIONS = "GENERAL OPTIONS";
    private static final String DEFAULT_URL = "https://ec2.amazonaws.com";
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String[] URL_DESC = new String[]{"Specify URL as the web service URL to use. Defaults to the value of", "'https://ec2.amazonaws.com' (us-east-1) or to that of the", "EC2_URL environment variable (if set). Overrides the default."};
    public static final String HEADERS = "headers";
    public static final String DEBUG = "debug";
    public static final String SHOW_NULL_FIELDS = "show-empty-fields";
    public static final String CONNECTION_TIMEOUT = "connection-timeout";
    public static final String REQUEST_TIMEOUT = "request-timeout";
    public static final String HELP = "help";
    public static final String PRIVATE_KEY = "private-key";
    public static final String CERT = "cert";
    public static final String URL = "url";
    public static final String VERBOSE = "verbose";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTIES_ARG = "PROPERTIES";
    public static final String MANIFEST = "manifest";
    public static final String MANIFEST_FILE_PATH = "manifest-file-path";
    public static final String AMI = "ami";
    public static final String INSTANCE = "instance";
    public static final String INSTANCE_ARG = "INSTANCE";
    public static final String INSTANCE_COUNT = "instance-count";
    public static final String KEY_ID = "key";
    public static final String KEY_ID_ARG = "KEY";
    public static final String GROUP = "group";
    public static final String GROUP_ARG = "GROUP";
    public static final String GROUP_ID = "group-id";
    public static final String GROUP_ID_ARG = "GROUP_ID";
    public static final String USER_DATA = "user-data";
    public static final String USER_DATA_ARG = "USERDATA";
    public static final String USER_DATA_FILE = "user-data-file";
    public static final String USER_DATA_FILE_ARG = "DATA-FILE";
    public static final String ADDRESSING = "addressing";
    public static final String INSTANCE_TYPE = "instance-type";
    public static final String INSTANCE_TYPE_ARG = "INSTANCETYPE";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_ARG = "DESCRIPTION";
    public static final String PRODUCT_DESCRIPTION = "product-description";
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_ARG = "PROTOCOL";
    public static final String PORT_RANGE = "port-range";
    public static final String PORT_RANGE_ARG = "PORT_RANGE";
    public static final String SOURCE_SUBNET = "source-subnet";
    public static final String DEST_SUBNET = "dest-subnet";
    public static final String SOURCE_GROUP = "source-group";
    public static final String SOURCE_GROUP_USER = "source-group-user";
    public static final String SOURCE_OR_DEST_GROUP = "source-or-dest-group";
    public static final String SOURCE_OR_DEST_GROUP_USER = "source-or-dest-group-user";
    public static final String TIMESTAMP = "timestamp";
    public static final String ICMP_TYPE_CODE = "icmp-type-code";
    public static final String ICMP_TYPE_CODE_ARG = "ICMP_TYPE_CODE";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String ATTRIB = "attrib";
    public static final String ITEM = "item";
    public static final String OWNER = "owner";
    public static final String OWNER_ARG = "OWNER";
    public static final String EXECUTABLE_BY = "executable-by";
    public static final String EXECUTABLE_BY_ARG = "USER";
    public static final String ALL = "all";
    public static final String LAUNCH_PERMISSION = "launch-permission";
    public static final String PRODUCT_CODE = "product-code";
    public static final String RAW_CONSOLE_OUTPUT = "raw-console-output";
    public static final String CREATE_VOLUME_PERMISSION = "create-volume-permission";
    public static final String AMAZON = "amazon";
    public static final String SELF = "self";
    public static final String EXPLICIT = "explicit";
    public static final String AVAILABILITY_ZONE = "availability-zone";
    public static final String AVAILABILITY_ZONE_ARG = "ZONE";
    public static final String KERNEL = "kernel";
    public static final String KERNEL_ARG = "KERNEL";
    public static final String PLACEMENT_GROUP = "placement-group";
    public static final String[] PLACEMENT_GROUP_DESC = new String[]{"Specifies the placement group into which the instances ", "should be launched."};
    public static final String PLACEMENT_GROUP_ARG = "GROUP_NAME";
    public static final String RAMDISK = "ramdisk";
    public static final String RAMDISK_ARG = "RAMDISK";
    public static final String MAPPING_ARG = "MAPPING";
    public static final String PRIV_LAUNCH_KEY = "priv-launch-key";
    public static final String BLOCK_DEVICE_MAPPING = "block-device-mapping";
    public static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    public static final String VOLUME = "volume";
    public static final String VOLUME_ARG = "VOLUME";
    public static final String VOLUME_SIZE = "size";
    public static final String DEVICE = "device";
    public static final String DEVICE_ARG = "DEVICE";
    public static final String SNAPSHOT = "snapshot";
    public static final String SNAPSHOT_ARG = "SNAPSHOT";
    public static final String COMMITTED_IOPS = "committed-iops";
    public static final String COMMITTED_IOPS_ARG = "IOPS";
    public static final String FORCE = "force";
    public static final String NO_REBOOT = "no-reboot";
    public static final String OWNER_AKID = "owner-akid";
    public static final String OWNER_AKID_ARG = "OWNERAKID";
    public static final String OWNER_SAK_ARG = "SECRETKEY";
    public static final String OWNER_SAK = "owner-sak";
    public static final String BUCKET = "bucket";
    public static final String BUCKET_ARG = "BUCKET";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String PREFIX = "prefix";
    public static final String PREFIX_ARG = "PREFIX";
    public static final String EXPIRES = "expires";
    public static final String POLICY = "policy";
    public static final String POLICY_SIGNATURE = "policy-signature";
    public static final String BUNDLE = "bundle";
    public static final String NO_BUCKET_SETUP = "no-bucket-setup";
    public static final String MONITOR = "monitor";
    public static final String MONITOR_ARG = "MONITOR";
    public static final String MONITORING = "monitoring";
    public static final String MONITORING_ARG = "MONITORING";
    public static final String ARCHITECTURE = "architecture";
    public static final String ARCHITECTURE_ARG = "ARCHITECTURE";
    public static final String NAME = "name";
    public static final String NAME_ARG = "NAME";
    public static final String DISABLE_API_TERMINATION = "disable-api-termination";
    public static final String BOOLEAN_ARG = "BOOLEAN";
    public static final String INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR = "instance-initiated-shutdown-behavior";
    public static final String INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_ARG = "BEHAVIOR";
    public static final String LICENSE_ID_ARG = "LICENSE";
    public static final String CAPACITY = "capacity";
    public static final String CAPACITY_ARG = "CAPACITY";
    public static final String LICENSE_POOL = "license-pool";
    public static final String PRIVATE_IP_ADDRESS = "private-ip-address";
    public static final String ALLOCATION_ID = "allocation-id";
    public static final String ALLOCATION_ID_ARG = "ALLOCATION_ID";
    public static final String[] ALLOCATION_ID_DESC = new String[]{"The ALLOCATION_ID to use for the operation.", "Used for VPC elastic IP addresses."};
    public static final String ASSOCIATION_ID = "association-id";
    public static final String ASSOCIATION_ID_ARG = "ASSOCIATION_ID";
    public static final String ASSOCIATION_ID_DESC = "The ASSOCIATION_ID to use for the operation, used for VPC associations";
    public static final String INTERFACE_ID = "interface-id";
    public static final String INTERFACE_ID_ARG = "INTERFACE_ID";
    public static final String INTERFACE_ID_DESC = "The INTERFACE_ID to use for the operation, used for VPC elastic IP addresses";
    public static final String PRICE = "price";
    public static final String REQUEST_TYPE = "type";
    public static final String VALID_UNTIL = "valid-until";
    public static final String VALID_FROM = "valid-from";
    public static final String LAUNCH_GROUP = "launch-group";
    public static final String AZ_GROUP = "availability-zone-group";
    public static final String REQUEST_ID = "request-id";
    public static final String START_TIME = "start-time";
    public static final String END_TIME = "end-time";
    public static final String MAX_RESULTS = "max-results";
    public static final String REGION = "region";
    public static final String REGION_ARG = "REGION";
    public static final String[] REGION_DESC = new String[]{"Specify REGION as the web service region to use.", "This option will override the URL specified by the \"-U URL\" option", "and EC2_URL environment variable."};
    public static final String DEFAULT_HOST = "ec2.amazonaws.com";
    public static final String OWNER_SAK_DESC = BaseCmd.joinDescription(new String[]{"AWS Secret Access Key of the owner of BUCKET, used to sign the upload", "policy. This parameter is required to generate a policy if --policy", "is not given, and to sign a given or generated policy if --policy-signature", "is not given. This parameter value is not sent to EC2."});
    public static final String OWNER_AKID_DESC = "AWS Access Key Id of the owner of BUCKET.";
    public static final String TYPE = "type";
    public static final String TYPE_ARG = "TYPE";
    public static final String IP_ADDRESS = "ip";
    public static final String IP_ADDRESS_ARG = "IP_ADDRESS";
    public static final String BGP_ASN = "bgp-asn";
    public static final String BGP_ASN_ARG = "BGP_ASN";
    public static final String VPC = "vpc";
    public static final String VPC_ARG = "VPC";
    public static final String CUSTOMER_GATEWAY = "customer-gateway";
    public static final String CUSTOMER_GATEWAY_ARG = "CUSTOMER_GATEWAY";
    public static final String VPN_GATEWAY = "vpn-gateway";
    public static final String VPN_GATEWAY_ARG = "VPN_GATEWAY";
    public static final String VPN_CONNECTION = "vpn-connection";
    public static final String SUBNET = "subnet";
    public static final String SUBNET_ARG = "SUBNET";
    public static final String DHCP_OPTIONS = "dhcp-options";
    public static final String DHCP_OPTIONS_ARG = "DHCP_OPTIONS";
    public static final String OUTPUT_FORMAT = "format";
    public static final String OUTPUT_FORMAT_ARG = "FORMAT";
    public static final String CIDR = "cidr";
    public static final String CIDR_ARG = "CIDR";
    public static final String STYLESHEET = "stylesheet";
    public static final String STYLESHEET_ARG = "STYLESHEET";
    public static final String IMAGE_LOCATION_ARG = "IMAGE_LOCATION";
    public static final String GROUP_NAME = "group-name";
    public static final String STRATEGY = "strategy";
    public static final String STRATEGY_ARG = "STRATEGY";
    public static final String NETWORK_ACL = "network-acl";
    public static final String NETWORK_ACL_ARG = "NETWORK_ACL";
    public static final String ASSOCIATION = "association";
    public static final String RULE_NUMBER = "rule-number";
    public static final String RULE_NUMBER_ARG = "RULE_NUMBER";
    public static final String EGRESS = "egress";
    public static final String INGRESS = "ingress";
    public static final String ALLOW = "allow";
    public static final String DENY = "deny";
    public static final String ROUTE_TABLE = "route-table";
    public static final String ROUTE_TABLE_ARG = "ROUTE_TABLE";
    public static final String GATEWAY = "gateway";
    public static final String GATEWAY_ARG = "GATEWAY";
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_ARG = "DOMAIN";
    public static final String ROOT_DEVICE = "root-device-name";
    public static final String ROOT_DEVICE_ARG = "ROOTDEVICENAME";
    public static final String BLOCK_DEVICE = "block-device";
    public static final String BLOCK_DEVICE_ARG = "BLOCKDEVICE";
    public static final String FORMAT = "format";
    public static final String FORMAT_ARG = "FORMAT";
    public static final String DISK_IMAGE = "disk-image";
    public static final String VOLUME_DASH_SIZE = "volume-size";
    public static final String VOLUME_DASH_SIZE_ARG = "SIZE";
    public static final String IGNORE_REGION_AFFINITY = "ignore-region-affinity";
    public static final String PLATFORM = "platform";
    public static final String PLATFORM_ARG = "PLATFORM";
    public static final String IMPORT_URL = "manifest-url";
    public static final String IMPORT_URL_ARG = "url";
    public static final String TASK = "task";
    public static final String TASK_ARG = "TASK-ID";
    public static final String DRY_RUN = "dry-run";
    public static final String DONT_VERIFY_FORMAT = "dont-verify-format";
    public static final String NO_UPLOAD = "no-upload";
    public static final String TENANCY = "tenancy";
    public static final String TENANCY_ARG = "TENANCY";
    public static final String FILTER = "filter";
    public static final String FILTER_ARG = "FILTER";
    public static final String FILTER_SHORT_OPTION = "F";
    public static final String FILTER_DESC = "Add a filter criterion for the result-set.";
    public static final String TAG = "tag";
    public static final String TAG_ARG = "TAG";
    public static final String TAG_DESC = "Tag in the form of key[=value].";
    public static final Pattern TAG_PATTERN = Pattern.compile("^([^=]+)(?:=([^=]*))?$");
    public static final String[] ATTRIBUTE_ARGS = new String[]{"launch-permission", "product-code", "kernel", "ramdisk", "block-device-mapping"};
    public static final String[] SNAPSHOT_ATTRIBUTE_ARGS = new String[]{"create-volume-permission"};
    public static final String[] ATTRIBUTE_OP_ARGS = new String[]{"add", "remove"};
    protected String name;
    protected List<String> aliases;
    private Options options = new Options();
    protected CommandLine cmd = null;
    private Map<String, String> defaultValues = new HashMap<String, String>();
    private boolean showHelp = false;
    private boolean invalidArgument = false;

    public BaseCmd(String name, String alias) {
        this(name, new String[]{alias});
    }

    public BaseCmd(String name, String[] aliases) {
        this.name = name;
        this.aliases = Arrays.asList(aliases);
    }

    public void printSynopsis() {
        System.out.println("  SYNOPSIS");
        System.out.println("     " + this.name + " (" + this.aliases + ")");
        for (String option : this.getOptionStrings()) {
            System.out.println("     " + this.name + " " + this.getGlobalOptionString() + " " + option);
        }
    }

    protected String getURL() {
        String urlString = "";
        if (this.isOptionSet(REGION)) {
            urlString = String.format("https://ec2.%s.amazonaws.com", this.getOptionValue(REGION));
        } else if (this.isOptionSet("url") || this.hasDefault("url")) {
            urlString = this.getOptionValue("url");
        } else {
            throw new GeneralError("No value or default found for URL");
        }
        return urlString;
    }

    public void printGeneralNotes() {
        System.out.println("  GENERAL NOTES");
        System.out.println("     Any command option/parameter may be passed a value of '-' to indicate");
        System.out.println("     that values for that option should be read from stdin.");
    }

    protected String getGlobalOptionString() {
        return "[GENERAL OPTIONS]";
    }

    public void printDescription() {
        System.out.println("  DESCRIPTION");
    }

    public void printOptions() {
        this.printOptions(false);
    }

    public void printExtraOptionsHeader() {
        System.out.println("  SPECIFIC OPTIONS");
        System.out.println();
    }

    public void printOptions(boolean moreOptions) {
        System.out.println();
        System.out.println("  GENERAL OPTIONS");
        System.out.println();
        if (this.isOnline()) {
            this.printOption(PRIVATE_KEY);
            this.printOption(CERT);
            this.printOption("url");
            this.printOption(REGION);
        }
        this.printOption(VERBOSE);
        this.printOption(HELP);
        this.printOption(HEADERS);
        this.printOption(DEBUG);
        this.printOption(SHOW_NULL_FIELDS);
        this.printOption(HIDE_TAGS);
        if (this.isOnline()) {
            this.printOption(CONNECTION_TIMEOUT);
            this.printOption(REQUEST_TIMEOUT);
            if (moreOptions) {
                this.printExtraOptionsHeader();
            }
        }
    }

    protected String rightPad(String s, int width) {
        while (s.length() < width) {
            s = s + ' ';
        }
        return s;
    }

    protected String joinDescription(String s) {
        return s;
    }

    protected static String joinDescription(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
            if (i >= strs.length - 1) continue;
            sb.append('\n');
            sb.append("          ");
        }
        return sb.toString();
    }

    protected void printOption(String l) {
        Option opt = this.options.getOption(l);
        String opts = this.describeOption(l);
        System.out.println("     " + opts);
        System.out.println("          " + opt.getDescription());
        System.out.println();
    }

    protected abstract String getOptionString();

    protected List<String> getOptionStrings() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getOptionString());
        return options;
    }

    protected boolean isOnline() {
        return true;
    }

    public void showUsage() {
        this.printSynopsis();
        this.printGeneralNotes();
        this.printDescription();
        this.printOptions();
    }

    protected void init(Options newOpts) {
        this.options.addOption(new Option(null, HIDE_TAGS, false, HIDE_TAGS_DESC));
        this.options.addOption(new Option("h", HELP, false, HELP_DESC));
        this.options.addOption(new Option("?", HELP, false, HELP_DESC));
        this.options.addOption(new Option("H", HEADERS, false, HEADERS_DESC));
        OptionBuilder.withLongOpt((String)DEBUG);
        OptionBuilder.withDescription((String)DEBUG_DESC);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SHOW_NULL_FIELDS);
        OptionBuilder.withDescription((String)SHOW_NULL_FIELDS_DESC);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)PRIVATE_KEY);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"KEY");
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(PRIVATE_KEY_DESC));
        this.options.addOption(OptionBuilder.create((String)"K"));
        OptionBuilder.withLongOpt((String)CERT);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)CERT_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(CERT_DESC));
        this.options.addOption(OptionBuilder.create((String)"C"));
        OptionBuilder.withLongOpt((String)REGION);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)REGION_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(REGION_DESC));
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)URL_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(URL_DESC));
        this.options.addOption(OptionBuilder.create((String)"U"));
        if (this.isOnline()) {
            OptionBuilder.withLongOpt((String)CONNECTION_TIMEOUT);
            OptionBuilder.hasArgs();
            OptionBuilder.withArgName((String)TIMEOUT_ARG);
            OptionBuilder.withDescription((String)CONNECTION_TIMEOUT_DESC);
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)REQUEST_TIMEOUT);
            OptionBuilder.hasArgs();
            OptionBuilder.withArgName((String)TIMEOUT_ARG);
            OptionBuilder.withDescription((String)REQUEST_TIMEOUT_DESC);
            this.options.addOption(OptionBuilder.create());
        }
        OptionBuilder.withLongOpt((String)VERBOSE);
        OptionBuilder.withDescription((String)VERBOSE_DESC);
        this.options.addOption(OptionBuilder.create((String)"v"));
        this.appendOpts(newOpts);
    }

    protected void appendOpts(Options newOpts) {
        for (Object o : newOpts.getOptions()) {
            this.options.addOption((Option)o);
        }
    }

    protected void parseOpts(String[] args) {
        EC2PosixParser parser = new EC2PosixParser();
        try {
            this.cmd = parser.parse(this.options, args, false);
        }
        catch (UnrecognizedOptionException uoe) {
            this.invalidArgument = true;
            this.showHelp = true;
        }
        catch (ParseException pe) {
            this.invalidArgument = true;
            this.showHelp = true;
        }
        if (this.cmd != null) {
            if (this.cmd.hasOption('h')) {
                this.showHelp = true;
            }
            if (this.cmd.hasOption('?')) {
                this.showHelp = true;
                this.invalidArgument = true;
            }
            if (this.isOnline()) {
                if (!this.isOptionSet(PRIVATE_KEY)) {
                    this.storeDefaultValue(PRIVATE_KEY, this.resolvePath(this.getEnvVar(new String[]{"EC2_PRIVATE_KEY"}, null)));
                } else {
                    this.storeDefaultValue(PRIVATE_KEY, this.resolvePath(this.getOptionValue(PRIVATE_KEY)));
                }
                if (!this.isOptionSet(CERT)) {
                    this.storeDefaultValue(CERT, this.resolvePath(this.getEnvVar(new String[]{"EC2_CERT"}, null)));
                } else {
                    this.storeDefaultValue(CERT, this.resolvePath(this.getOptionValue(CERT)));
                }
                if (!this.isOptionSet("url")) {
                    this.storeDefaultValue("url", this.getEnvVar(new String[]{"EC2_URL", "C3_URL", "AES_URL", "AES_XINO_URL"}, DEFAULT_URL));
                }
            }
        }
    }

    private String getEnvVar(String[] names, String defaultValue) {
        for (int i = 0; i < names.length; ++i) {
            String val = System.getenv(names[i]);
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    private String resolvePath(String path) {
        if (path == null) {
            return path;
        }
        String homeDir = System.getProperty("user.home");
        path = path.replace("~", homeDir);
        if (System.getProperty("ec2.cygwin") != null) {
            try {
                OsPipe fileConv = new OsPipe(new String[]{"cygpath.exe", "-w", path});
                String[] pathLines = fileConv.readLines();
                return pathLines[0];
            }
            catch (IOException e) {
                System.err.println("WARNING: Could not convert Cygwin path [" + e.getMessage() + "]");
            }
            catch (InterruptedException e) {
                System.err.println("WARNING: Interrupted while converting Cygwin path [" + e.getMessage() + "]");
            }
        }
        return path;
    }

    private void storeDefaultValue(String name, String value) {
        if (value == null) {
            return;
        }
        this.defaultValues.put(name, value);
    }

    protected boolean isOptionSet(String name) {
        return this.cmd != null && this.cmd.hasOption(name);
    }

    protected boolean hasDefault(String name) {
        return this.defaultValues.containsKey(name);
    }

    protected String getOptionValue(String name, String defaultValue) {
        if (this.isOptionSet(name)) {
            if (this.options.getOption(name).hasArg()) {
                return this.cmd.getOptionValue(name);
            }
            return "true";
        }
        if (this.defaultValues.containsKey(name)) {
            return this.defaultValues.get(name);
        }
        return defaultValue;
    }

    public String getOptionValue(String name) {
        if (this.isOptionSet(name)) {
            if (this.options.getOption(name).hasArg()) {
                return this.cmd.getOptionValue(name);
            }
            return "true";
        }
        if (this.defaultValues.containsKey(name)) {
            return this.defaultValues.get(name);
        }
        return null;
    }

    protected String[] getOptionValues(String name) {
        if (!this.cmd.hasOption(name)) {
            return new String[0];
        }
        return this.cmd.getOptionValues(name);
    }

    protected String[] getNonOptions() {
        return this.cmd.getArgs();
    }

    protected void assertNonOptionSet(String name) {
        if (this.cmd.getArgList() == null || this.cmd.getArgList().size() == 0) {
            throw new MissingNonOption(name);
        }
    }

    protected void assertOptionSet(String name) {
        if (!this.isOptionSet(name) && !this.hasDefault(name)) {
            throw new MissingArgument(name);
        }
    }

    protected void assertOptionNotSet(String name) {
        if (this.isOptionSet(name)) {
            throw new UnexpectedArgument(name);
        }
    }

    protected void assertOptionsNotSet(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i])) continue;
            throw new UnexpectedArgument(this.name);
        }
    }

    protected void assertAtLeastOneOptionSet(String[] names) {
        boolean valid = false;
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i])) continue;
            valid = true;
        }
        if (!valid) {
            throw new MissingAtLeastOneArgument(names);
        }
    }

    protected void assertOnlyOneOptionSet(String[] names) {
        int count = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i]) || ++count <= 1) continue;
            throw new OnlyOneArgumentExpected(names);
        }
        if (count != 1) {
            throw new OnlyOneArgumentExpected(names);
        }
    }

    protected void warnIfTooManyNonOptions() {
        String[] nonOpts = this.getNonOptions();
        if (nonOpts.length > 1) {
            StringBuffer sb = new StringBuffer(nonOpts[1]);
            for (int i = 2; i < nonOpts.length; ++i) {
                sb.append(", " + nonOpts[i]);
            }
            System.err.println("WARNING:  Ignoring extra parameter(s): [ " + sb + " ]");
        }
    }

    protected int[] parseRange(String range) {
        int max;
        int min;
        if ("-1".equals(range)) {
            return new int[]{0, 65535};
        }
        String[] parts = range.split("-");
        if (parts.length == 2) {
            try {
                min = Integer.parseInt(parts[0]);
                max = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw (InvalidRange)new InvalidRange(range).initCause(e);
            }
        }
        try {
            min = max = Integer.parseInt(range);
        }
        catch (NumberFormatException e) {
            throw (InvalidRange)new InvalidRange(range).initCause(e);
        }
        if (max < min || min < 0 || max < 0 || min > 65535 || max > 65535) {
            throw new InvalidRange(range);
        }
        return new int[]{min, max};
    }

    protected String describeOption(String opt) {
        Option o = this.options.getOption(opt);
        if (o == null) {
            throw new RuntimeException("Unknown option " + opt);
        }
        String shortName = o.getOpt();
        String longName = o.getLongOpt();
        String description = null;
        description = shortName == null ? "--" + longName : "-" + shortName + ", --" + longName;
        if (o.hasArg() && o.hasArgName() && !o.getArgName().equalsIgnoreCase("arg")) {
            description = description + " " + o.getArgName();
        }
        return description;
    }

    protected String describeOptions(String[] opts) {
        StringBuffer sb = new StringBuffer(this.describeOption(opts[0]));
        for (int i = 1; i < opts.length; ++i) {
            sb.append(", ");
            sb.append(this.describeOption(opts[i]));
        }
        return sb.toString();
    }

    private void setUserAgent() {
        this.getClass().getClassLoader().getResourceAsStream("ec2version.properties");
        String ua = "ec2-api-tools";
        try {
            ua = ua + " " + ShowVersion.getVersion();
        }
        catch (IOException e) {
            ua = ua + " [ioexception]";
        }
        System.setProperty("httpclient.useragent", ua);
        if (this.isOptionSet(VERBOSE)) {
            System.out.println("Setting User-Agent to [" + ua + "]");
        }
    }

    private void reportException(String[] msg, Throwable e, boolean showStackTrace) {
        for (String line : msg) {
            System.err.println(line);
        }
        if (showStackTrace || this.isOptionSet(DEBUG)) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private void reportException(String msg, Throwable e, boolean showStackTrace) {
        this.reportException(new String[]{msg}, e, showStackTrace);
    }

    public void invoke() {
        if (this.showHelp) {
            this.showUsage();
            if (this.invalidArgument) {
                System.exit(1);
            }
            return;
        }
        if (this.isOptionSet(VERBOSE)) {
            System.setProperty("com.amazon.aes.webservices.client.echo", "both");
        }
        if (this.isOptionSet(CONNECTION_TIMEOUT)) {
            System.setProperty("com.amazon.aes.webservices.client.connectionTimeout", this.getOptionValue(CONNECTION_TIMEOUT) + "000");
        }
        if (this.isOptionSet(REQUEST_TIMEOUT)) {
            System.setProperty("com.amazon.aes.webservices.client.requestTimeout", this.getOptionValue(REQUEST_TIMEOUT) + "000");
        }
        this.setUserAgent();
        try {
            if (this.isOnline()) {
                this.assertOptionSet("url");
                this.assertOptionSet(PRIVATE_KEY);
                this.assertOptionSet(CERT);
                URL url = new URL(this.getURL());
                Jec2Impl jec2 = new Jec2Impl(url, this.getOptionValue(PRIVATE_KEY), this.getOptionValue(CERT));
                if (!this.invokeOnline((Jec2)jec2, new Outputter(this.isOptionSet(HEADERS), this.isOptionSet(DEBUG), this.isOptionSet(SHOW_NULL_FIELDS), this.isOptionSet(VERBOSE), !this.isOptionSet(HIDE_TAGS)))) {
                    System.exit(1);
                }
            } else if (!this.invokeOffline(new Outputter(this.isOptionSet(HEADERS), this.isOptionSet(DEBUG), this.isOptionSet(SHOW_NULL_FIELDS), this.isOptionSet(VERBOSE)))) {
                System.exit(1);
            }
        }
        catch (MissingArgument e) {
            this.reportException("Required option '" + this.describeOption(e.getName()) + "' missing (-h for usage)", (Throwable)e, false);
        }
        catch (UnexpectedArgument e) {
            this.reportException("Unexpected option '" + this.describeOption(e.getName()) + "' encountered (-h for usage)", (Throwable)e, false);
        }
        catch (MissingNonOption e) {
            this.reportException("Required parameter '" + e.getName() + "' missing (-h for usage)", (Throwable)e, false);
        }
        catch (MissingAtLeastOneArgument e) {
            this.reportException("One of required options [" + this.describeOptions(e.getNames()) + "] missing (-h for usage)", (Throwable)e, false);
        }
        catch (OnlyOneArgumentExpected e) {
            this.reportException("One, and only one, of [" + this.describeOptions(e.getNames()) + "] expected (-h for usage)", (Throwable)e, false);
        }
        catch (InvalidArgument e) {
            this.reportException("Invalid argument for option '" + this.describeOption(e.getName()) + "': '" + e.getValue() + "' (-h for usage)", (Throwable)e, false);
        }
        catch (InvalidRange e) {
            this.reportException("Invalid range specified: '" + e.getRange() + "' (use m-n)", (Throwable)e, false);
        }
        catch (InvalidArgumentCombination e) {
            this.reportException(e.getMessage() + " (-h for usage)", (Throwable)e, false);
        }
        catch (MalformedURLException e) {
            this.reportException("Malformed URL: '" + this.getURL() + "'", (Throwable)e, false);
        }
        catch (FileNotFoundException e) {
            this.reportException("File not found: '" + e.getMessage() + "'", (Throwable)e, false);
        }
        catch (UnknownHostException e) {
            this.reportException("Unknown host: '" + this.getURL() + "'", (Throwable)e, false);
        }
        catch (GeneralError e) {
            this.reportException(e.getMessage(), (Throwable)e, false);
        }
        catch (Jec2SoapFaultException e) {
            String faultCode = e.getFault().getFaultCode().getLocalPart();
            String faultString = faultCode + ": " + e.getFault().getMessage();
            if (faultCode.equals("RequestExpired")) {
                String suggestion = "Your system clock may not be set to the correct time.  Please set it correctly and try again.";
                this.reportException(new String[]{faultString, suggestion}, (Throwable)e, false);
            } else {
                this.reportException(faultString, (Throwable)e, false);
            }
        }
        catch (SocketTimeoutException e) {
            this.reportException(new String[]{"Read timeout. Please try again later. If this persists please visit the", "AWS developer forums to see if it's the result of a known issue."}, (Throwable)e, false);
        }
        catch (ConnectTimeoutException e) {
            this.reportException(new String[]{"Connection timeout. Please check your URL is correct and try again. If this persists please visit the", "AWS developer forums to see if it's the result of a known issue."}, (Throwable)e, false);
        }
        catch (InvalidKeyException e) {
            this.reportException(new String[]{"Invalid private key: " + e.getMessage(), "Please ensure the file contains a valid private key."}, (Throwable)e, false);
        }
        catch (InvalidCertException e) {
            this.reportException(new String[]{"Invalid X509 certificate: " + e.getMessage(), "Please ensure the file contains a valid X509 certificate."}, (Throwable)e, false);
        }
        catch (ConnectException e) {
            this.reportException("Unable to connect to host: '" + this.getURL() + "'", (Throwable)e, false);
        }
        catch (Exception e) {
            this.reportException("Unexpected error:", (Throwable)e, true);
        }
        System.exit(0);
    }

    public String getUserDataFile(String str) throws IOException {
        String base64 = null;
        File file = new File(str);
        if (file.canRead() && file.isFile()) {
            try {
                int content_length = (int)file.length();
                FileInputStream ifs = new FileInputStream(file);
                byte[] contents = new byte[content_length];
                int nread = ifs.read(contents);
                assert (nread == content_length);
                base64 = new BASE64Encoder().encode(contents);
            }
            catch (FileNotFoundException nfe) {
                System.err.println("File not found? This is of course impossible.\n" + nfe.toString());
                throw nfe;
            }
        } else {
            throw new InvalidArgument(USER_DATA_FILE, str);
        }
        return base64.replaceAll("\\s", "");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        throw new RuntimeException("Unimplemented invokeOnline called");
    }

    protected boolean invokeOffline(Outputter out) throws Exception {
        throw new RuntimeException("Unimplemented invokeOffline called");
    }

    public String[] getNames() {
        ArrayList<String> names = new ArrayList<String>(this.aliases);
        names.add(this.name);
        return names.toArray(new String[names.size()]);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String desc) {
        return BaseCmd.createOptionWithArgs(opt, longOpt, desc, null);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String[] desc, String argName) {
        return BaseCmd.createOptionWithArgs(opt, longOpt, BaseCmd.joinDescription(desc), argName);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String desc, String argName) {
        return BaseCmd.createOption(opt, longOpt, desc, argName, true);
    }

    public static Option createOption(String opt, String longOpt, String[] desc) {
        return BaseCmd.createOption(opt, longOpt, BaseCmd.joinDescription(desc), null, false);
    }

    public static Option createOption(String opt, String longOpt, String desc) {
        return BaseCmd.createOption(opt, longOpt, desc, null, false);
    }

    public static Option createOption(String opt, String longOpt, String desc, String argName, boolean hasArg) {
        Option option = new Option(opt, longOpt, hasArg, desc);
        if (hasArg) {
            option.setArgs(-2);
        }
        if (argName != null) {
            option.setArgName(argName);
        }
        return option;
    }

    public Map<String, List<String>> getFilterMap(boolean useNamedParameter) {
        String[] filterOptions = useNamedParameter ? this.getOptionValues(FILTER) : this.getNonOptions();
        LinkedHashMap<String, List<String>> filterMap = new LinkedHashMap<String, List<String>>();
        if (filterOptions != null) {
            for (String filterOption : filterOptions) {
                int index = filterOption.indexOf(61);
                if (index < 0) {
                    throw new GeneralError("Filter definitions must have format 'name=value', but found '" + filterOption + "'");
                }
                String filterKey = filterOption.substring(0, index);
                List filterValues = (List)filterMap.get(filterKey);
                List<String> newFilterValues = Arrays.asList(filterOption.substring(index + 1).split(","));
                if (filterValues == null) {
                    filterMap.put(filterKey, new LinkedList<String>(newFilterValues));
                    continue;
                }
                filterValues.addAll(newFilterValues);
            }
        }
        return filterMap;
    }

    public List<Filter> getFilters(boolean useNamedParameter) {
        Map<String, List<String>> filterMap = this.getFilterMap(useNamedParameter);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Map.Entry<String, List<String>> filterEntry : filterMap.entrySet()) {
            filters.add(new Filter(filterEntry.getKey(), filterEntry.getValue()));
        }
        return filters;
    }

    public List<TagType> getTags() throws Exception {
        ArrayList<TagType> tags = new ArrayList<TagType>();
        for (String tagStr : Arrays.asList(this.getOptionValues(TAG))) {
            Matcher m = TAG_PATTERN.matcher(tagStr);
            if (m.matches()) {
                TagType tag;
                if (m.groupCount() == 1) {
                    tag = new TagType(m.group(1));
                } else if (m.groupCount() == 2) {
                    tag = new TagType(m.group(1), m.group(2));
                } else {
                    throw new Exception("'" + tagStr + "' is not a valid tag key or key/value pair.");
                }
                tags.add(tag);
                continue;
            }
            throw new Exception("'" + tagStr + "' is not a valid tag key or key/value pair.");
        }
        return tags;
    }
}

