/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CreateImage
extends BaseCmd {
    private static final String[] NAME_DESC = new String[]{"The name of the image."};
    private static final String[] DESCRIPTION_DESC = new String[]{"The description of the image."};
    private static final String[] NO_REBOOT_DESC = new String[]{"If specified, the instance will not be rebooted during the bundle", "process."};

    public CreateImage(String[] args) {
        super("ec2cim", "ec2-create-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options().addOption(CreateImage.createOptionWithArgs("n", "name", CreateImage.joinDescription(NAME_DESC), "NAME")).addOption(CreateImage.createOptionWithArgs("d", "description", CreateImage.joinDescription(DESCRIPTION_DESC), "DESCRIPTION")).addOption(new Option(null, "no-reboot", false, CreateImage.joinDescription(NO_REBOOT_DESC)));
    }

    @Override
    protected String getOptionString() {
        return "INSTANCE";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Register an AMI manifest for use with EC2.");
        System.out.println("     The MANIFEST parameter is the manifest (in S3) to register.");
        System.out.println("     e.g. mybucketname/image.manifest");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("name");
        this.printOption("description");
        this.printOption("no-reboot");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String instanceId;
        String string = instanceId = this.getNonOptions().length > 0 ? this.getNonOptions()[0] : null;
        if (instanceId == null || "".equals(instanceId)) {
            throw new MissingNonOption("instance");
        }
        String name = this.getOptionValue("name");
        if (name == null || "".equals(name)) {
            throw new MissingArgument("name");
        }
        String description = this.getOptionValue("description");
        RequestResultPair rsp = jec2.createImage(instanceId, name, description, this.isOptionSet("no-reboot"));
        out.outputImageId(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new CreateImage(args).invoke();
    }
}

