/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.TagDescription;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateTags
extends BaseCmd {
    private static final Pattern CUSTOMER_GATEWAY_ID_PATTERN = Pattern.compile("^\\s*cgw-.*");
    private static final Pattern DHCP_OPTIONS_ID_PATTERN = Pattern.compile("^\\s*dopt-.*");
    private static final Pattern IMAGE_ID_PATTERN = Pattern.compile("^\\s*a[mkr]i-.*");
    private static final Pattern INSTANCE_ID_PATTERN = Pattern.compile("^\\s*i-.*");
    private static final Pattern LICENSE_ID_PATTERN = Pattern.compile("^\\s*lic-.*");
    private static final Pattern RESERVED_INSTANCES_ID_PATTERN = Pattern.compile("^\\s*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\s*$");
    private static final Pattern SNAPSHOT_ID_PATTERN = Pattern.compile("^\\s*snap-.*");
    private static final Pattern SPOT_INSTANCE_REQUEST_ID_PATTERN = Pattern.compile("^\\s*sir-.*");
    private static final Pattern SUBNET_ID_PATTERN = Pattern.compile("^\\s*subnet-.*");
    private static final Pattern VOLUME_ID_PATTERN = Pattern.compile("^\\s*vol-.*");
    private static final Pattern VPC_ID_PATTERN = Pattern.compile("^\\s*vpc-.*");
    private static Map<String, Pattern> resourcePatternMap = new HashMap<String, Pattern>();

    public CreateTags(String[] args) {
        super("ec2addtag", new String[]{"ec2-create-tags", "ec2tag"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"tag");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TAG");
        OptionBuilder.withDescription((String)"Tag in the form of key[=value].");
        o.addOption(OptionBuilder.create((String)"t"));
        return o;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Adds a set of tags to a set of resources. To update a tag's key or value, you also use CreateTags.");
        System.out.println("\t The new values overwrite the old values. ");
    }

    @Override
    protected String getOptionString() {
        return "RESOURCE_ID [RESOURCE_ID ...] --tag KEY[=VALUE] [--tag KEY[=VALUE] ...]";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("tag");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        List<String> resourceIds = Arrays.asList(this.getNonOptions());
        List<TagType> tags = this.getTags();
        this.assertNonOptionSet("RESOURCE_ID");
        this.assertOptionSet("tag");
        jec2.createTags(resourceIds, tags);
        this.printTagsFromUserInput(out, resourceIds, tags);
        return true;
    }

    private void printTagsFromUserInput(Outputter out, List<String> resourceIds, List<TagType> tags) {
        for (String resourceId : resourceIds) {
            String resourceType = "";
            for (Map.Entry<String, Pattern> entry : resourcePatternMap.entrySet()) {
                Matcher m = entry.getValue().matcher(resourceId);
                if (m == null || !m.matches()) continue;
                resourceType = entry.getKey();
                break;
            }
            for (TagType tag : tags) {
                out.outputTag(System.out, new TagDescription(resourceId, resourceType, tag.getKey(), tag.getValue()));
            }
        }
    }

    public static void main(String[] args) {
        new CreateTags(args).invoke();
    }

    static {
        resourcePatternMap.put("customer-gateway", CUSTOMER_GATEWAY_ID_PATTERN);
        resourcePatternMap.put("dhcp-options", DHCP_OPTIONS_ID_PATTERN);
        resourcePatternMap.put("image", IMAGE_ID_PATTERN);
        resourcePatternMap.put("instance", INSTANCE_ID_PATTERN);
        resourcePatternMap.put("license", LICENSE_ID_PATTERN);
        resourcePatternMap.put("reserved-instances", RESERVED_INSTANCES_ID_PATTERN);
        resourcePatternMap.put("snapshot", SNAPSHOT_ID_PATTERN);
        resourcePatternMap.put("spot-instance-request", SPOT_INSTANCE_REQUEST_ID_PATTERN);
        resourcePatternMap.put("subnet", SUBNET_ID_PATTERN);
        resourcePatternMap.put("volume", VOLUME_ID_PATTERN);
        resourcePatternMap.put("vpc", VPC_ID_PATTERN);
    }
}

