/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ElasticIpAssociationDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssociateAddress
extends BaseCmd {
    private static final String[] INSTANCE_DESC = new String[]{"Instance with which to associate an IP."};

    public AssociateAddress(String[] args) {
        super("ec2assocaddr", "ec2-associate-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(INSTANCE_DESC));
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"allocation-id");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AssociateAddress.joinDescription(ALLOCATION_ID_DESC));
        result.addOption(OptionBuilder.create((String)"a"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "{ IP | -a ALLOCATION_ID } -i INSTANCE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("allocation-id");
        this.printOption("instance");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Associate a public address with an instance.");
        System.out.println("     The IP parameter is the address to associate for non-VPC instances.");
        System.out.println("     VPC instances must specify an allocation ID instead.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String publicIp = null;
        String allocationId = null;
        String instanceId = null;
        this.assertOptionSet("instance");
        instanceId = this.getOptionValue("instance");
        if (this.isOptionSet("allocation-id")) {
            if (this.getNonOptions().length > 0) {
                throw new InvalidArgumentCombination("Specify either IP (non-VPC) or -a allocation-id (VPC), not both.");
            }
            allocationId = this.getOptionValue("allocation-id");
        } else {
            this.assertNonOptionSet("IP");
            publicIp = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
        }
        RequestResultPair resPair = jec2.associateAddress(publicIp, instanceId, allocationId);
        out.outputAddressAssociation(System.out, publicIp, instanceId, allocationId, ((ElasticIpAssociationDescription)resPair.getResponse()).getAssociationId());
        out.printRequestId(System.out, resPair.getRequestId());
        return true;
    }

    public static void main(String[] args) {
        new AssociateAddress(args).invoke();
    }
}

