/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ElasticIpDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AllocateAddress
extends BaseCmd {
    public static final String[] DOMAIN_DESC = new String[]{"If DOMAIN is specified as 'vpc', the IP address returned can", "be associated with VPC instances.  If this option is not", "specified, the IP address can only be associated with non-VPC", "instances."};

    public AllocateAddress(String[] args) {
        super("ec2allocaddr", "ec2-allocate-address");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"domain");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DOMAIN");
        OptionBuilder.withDescription((String)AllocateAddress.joinDescription(DOMAIN_DESC));
        o.addOption(OptionBuilder.create((String)"d"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return " [ -d DOMAIN ] ";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Allocate an elastic IP address.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("domain");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rspPair;
        this.warnIfTooManyNonOptions();
        if (this.isOptionSet("domain")) {
            String domain = this.getOptionValue("domain");
            if (!domain.equalsIgnoreCase("vpc")) {
                throw new InvalidArgument("domain", domain);
            }
            rspPair = jec2.allocateAddress(domain);
        } else {
            rspPair = jec2.allocateAddress();
        }
        ElasticIpDescription rsp = (ElasticIpDescription)rspPair.getResponse();
        out.outputAddress(System.out, rsp.getPublicIp(), null, rsp.getDomain(), rsp.getAllocationId(), null);
        out.printRequestId(System.out, rspPair.getRequestId());
        return true;
    }

    public static void main(String[] args) {
        new AllocateAddress(args).invoke();
    }
}

