/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.Uploadable;
import com.amazon.aes.webservices.client.vmconversion.DiskImageVerifier;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ResumeImport
extends Uploadable {
    public static final String TASK_DESC = "Specifies the conversion task id for the upload. [REQUIRED]";
    public static final String DRY_RUN_DESC = "Do not upload the file, only validate the disk image.";
    public static final String[] DONT_VERIFY_FORMAT_DESC = new String[]{"Do not verify the file format.  This is dangerous and may result in a failed", "conversion. "};
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, to sign URLs for accessing", "the file being uploaded to S3. This parameter value is not sent to EC2.", "[REQUIRED]"};
    protected String taskId;

    public ResumeImport(String[] args) {
        super("ec2rim", "ec2-resume-import");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"task");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TASK-ID");
        OptionBuilder.withDescription((String)this.joinDescription(TASK_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"dont-verify-format");
        OptionBuilder.withDescription((String)ResumeImport.joinDescription(DONT_VERIFY_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dry-run");
        OptionBuilder.withDescription((String)this.joinDescription(DRY_RUN_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET. [REQUIRED]"));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)ResumeImport.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"user-threads");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"THREADS");
        OptionBuilder.withDescription((String)ResumeImport.joinDescription(USER_THREADS_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"expires");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DAYS");
        OptionBuilder.withDescription((String)ResumeImport.joinDescription(EXPIRES_DESC));
        options.addOption(OptionBuilder.create((String)"x"));
        return options;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] disk-image";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Upload the disk image associated with the conversion task id.  Prior to");
        System.out.println("     upload, the disk image will be validated against the expected format");
        System.out.println("     for the conversion task.  If a previous upload attempt was aborted, the");
        System.out.println("     upload will (by default) resume from where it was interrupted.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("task");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("expires");
        this.printOption("user-threads");
        this.printOption("dry-run");
        this.printOption("dont-verify-format");
    }

    @Override
    protected void validateParameters() throws GeneralError, VerificationException {
        super.validateParameters();
        this.assertOptionSet("task");
        this.taskId = this.getOptionValue("task");
        this.verifyFormat = !this.isOptionSet("dont-verify-format");
    }

    protected void verifyDiskFormat(ImportVolumeConversionTask importTask) throws VerificationException {
        DiskImageVerifier verifier = new DiskImageVerifier(this.imageFile);
        verifier.validateFileLength(importTask.getDiskImageSize());
        if (this.verifyFormat) {
            verifier.validateImageFormat(importTask.getDiskImageFormat(), importTask.getVolumeSize());
        }
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateParameters();
            this.task = jec2.describeConversionTask(this.taskId);
            ImportVolumeConversionTask importTask = this.retrieveImportVolumeConversionTask(this.task);
            this.verifyDiskFormat(importTask);
            return this.uploadDisk(importTask);
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new ResumeImport(args).invoke();
    }
}

