/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockDeviceMappingDescription {
    private static final Pattern BLOCK_DEVICE_MAPPING_PATTERN = Pattern.compile("^(.*?)=(.*?)(?:\\:(.*?))?(?:\\:(.*?))?");
    private final String deviceName;
    private final Type type;
    private final String virtualName;
    private final EbsSnapshotDescription snapshot;

    public static BlockDeviceMappingDescription valueOf(String blockDeviceMapping) throws Exception {
        Matcher matcher = BLOCK_DEVICE_MAPPING_PATTERN.matcher(blockDeviceMapping);
        if (!matcher.matches()) {
            throw new Exception("Invalid format; no match found.");
        }
        String deviceName = matcher.group(1).trim();
        String virtualName = matcher.group(2).trim();
        if (virtualName.equalsIgnoreCase("none")) {
            return new BlockDeviceMappingDescription(deviceName, Type.NO_DEVICE);
        }
        if (virtualName.length() == 0 || virtualName.toLowerCase().startsWith("snap")) {
            String snapshotId = null;
            if (matcher.group(2) != null && matcher.group(2).length() > 0) {
                snapshotId = matcher.group(2);
            }
            Integer volumeSize = null;
            if (matcher.group(3) != null && matcher.group(3).length() > 0) {
                volumeSize = Integer.valueOf(matcher.group(3));
            }
            Boolean deleteOnTermination = null;
            if (matcher.group(4) != null && matcher.group(4).length() > 0) {
                deleteOnTermination = Boolean.valueOf(matcher.group(4));
            }
            return new BlockDeviceMappingDescription(deviceName, Type.EBS, new EbsSnapshotDescription(snapshotId, volumeSize, deleteOnTermination));
        }
        return new BlockDeviceMappingDescription(deviceName, Type.EPHEMERAL, virtualName);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type) {
        this(deviceName, type, null, null);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type, String virtualName) {
        this(deviceName, type, virtualName, null);
    }

    public BlockDeviceMappingDescription(String deviceName, Type type, EbsSnapshotDescription snapshot) {
        this(deviceName, type, null, snapshot);
    }

    protected BlockDeviceMappingDescription(String deviceName, Type type, String virtualName, EbsSnapshotDescription snapshot) {
        this.type = type;
        this.deviceName = deviceName;
        this.virtualName = virtualName;
        this.snapshot = snapshot;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Type getType() {
        return this.type;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public EbsSnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    public static enum Type {
        EBS,
        EPHEMERAL,
        NO_DEVICE;

    }
}

