/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusContainer;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeInstanceStatus
extends BaseCmd {
    public DescribeInstanceStatus(String[] args) {
        super("ec2dins", "ec2-describe-instance-status");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "[-h] [INSTANCE [INSTANCE [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe the status for one or more instances and see if there are");
        System.out.println("     any associated events. Only instances that have events will be shown");
        System.out.println("     in the output.");
        System.out.println("");
        System.out.println("     How Events Work:");
        System.out.println("     ----------------");
        System.out.println("     An event is a reminder of an operation that will affect this instance.");
        System.out.println("     The fields NotBefore and NotAfter indicate the scheduled date that the");
        System.out.println("     event comes into effect:");
        System.out.println("       * NotBefore: the event will not occur before this time");
        System.out.println("       * NotAfter: the event will not occur after this time");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] instanceIds = this.getNonOptions();
        int maxResults = 1000;
        String nextToken = null;
        do {
            RequestResultPair rsp = instanceIds.length == 0 ? jec2.describeInstanceStatus(maxResults, this.getFilters(true), nextToken) : jec2.describeInstanceStatus(instanceIds, this.getFilters(true), nextToken);
            InstanceStatusContainer instanceStatusContainer = (InstanceStatusContainer)rsp.getResponse();
            out.outputInstanceStatusDescriptions(System.out, instanceStatusContainer.getInstanceStatusDescriptions());
            out.printRequestId(System.out, (RequestResult)rsp);
            nextToken = instanceStatusContainer.getNextToken();
            if (nextToken != "") continue;
            nextToken = null;
        } while (nextToken != null);
        return true;
    }

    public static void main(String[] args) {
        new DescribeInstanceStatus(args).invoke();
    }
}

