#ifndef CLICK_SQLSCRIPTEXPORT_HH
#define CLICK_SQLSCRIPTEXPORT_HH

#include <click/string.hh>
#include <click/vector.hh>

#include <iosfwd>

#include "dataexport.hh"               
#include "sql.hh"

CLICK_DECLS

/*
=c

SQLScriptExport([I<KEYWORDS>])

=s tnt

exports a SQL script that creates a table and loads data from a file generated
with FileExport

=d

SQLScriptExport outputs a SQL script that once executed creates a table and
loads the flow records into it. The table definition is automatically derived
from the configuration of Click elements that depends on FlowCache.

=e

This configuration collects a number of statistics for each flow in a trace,
and outputs them in /tmp/data. At the end /tmp/data.sql will contain a SQL
script to load the data file into a database table named Data.

ex :: FileExport(/tmp/data);
fex :: SQLScriptExport(/tmp/data.sql, TABLENAME Data, NEXT ex);
FromDump(tracefile.dump, STOP true, FORCE_IP true)
-> fc :: FlowCache(DATAEXPORTER fex)
-> FlowsStats
-> Discard;
DriverManager(wait, write fc.clear, stop)
                                              
=a

FlowsCache, FileExport
*/

class SQLScriptExport: public DataExport
{
    friend class SQLSyntax;
public:
    SQLScriptExport();
    ~SQLScriptExport();
    
    const char* class_name() const { return "SQLScriptExport"; }
    void* cast(const char* n);
        
    int configure(Vector<String>& conf, ErrorHandler* errh);
    int initialize(ErrorHandler* errh);
protected:
    void add_column(const Column& col);
    void add_constraint(const Constraint& con);
    void write(const String& val);
    void write_null();
    void done();
private:
    void create_sql_strings();
    String get_type(const Column& col);
    String get_constraint(const Constraint& con);
    bool is_string(const std::type_info* ti);
    String normalize_name(const String& name);

    bool initialized_;
    bool drop_table_;
    String filename_;
    String data_filename_;
    
    std::ofstream* os_;
    
    Vector<Column> cols_;
    Vector<Constraint> cons_;
    String table_name_;
    String table_sql_;
    String load_sql_;
};

CLICK_ENDDECLS
#endif

