#ifndef CLICK_SQLEXPORT_HH
#define CLICK_SQLEXPORT_HH

#include <click/string.hh>
#include <click/vector.hh>

#include "dataexport.hh"
#include "sql.hh"

CLICK_DECLS

class SQLExport: public DataExport
{
    friend class SQLSyntax;
protected:
    class Value
    {
    public:
        String val;
        bool null;

        Value(const String& s) : val(s), null(false) {}
        Value() : val("NULL"), null(true) {}
    };

public:
    SQLExport();
    ~SQLExport();
    
    const char* class_name() const { return "SQLExport"; }
    void* cast(const char* n);
        
    int configure(Vector<String>& conf, ErrorHandler* errh);
    int initialize(ErrorHandler* errh);
protected:
    void add_column(const Column& col);
    void add_constraint(const Constraint& con);
    void write(const String& val);
    void write_null();
    void done();
private:
    void create_sql_strings();
    String add_values(const String& sql);
    void create_table();
    void insert_data();
    void insert();
    void update();
    String get_type(const Column& col);
    String get_constraint(const Constraint& con);
    bool is_string(const std::type_info* ti);
    String normalize_name(const String& name);
private:
    bool initialized_;
    bool keep_connection_;
    bool append_to_table_;
    Vector<Column> cols_;
    Vector<Constraint> cons_;
    Vector<Value> vals_;
    String driver_;
    String url_;
    String table_name_;
    String table_sql_;
    String insert_sql_;
    String update_sql_;
    SQL::SQLConnection connection_;

    ErrorHandler *log;
};

CLICK_ENDDECLS
#endif
