/*
 * mysql.{cc,hh} -- MySQL data exporter
 * 
 * Sergio Mangialardi
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: mysql.cc 2208 2009-05-06 17:59:25Z marco $
 */

#include <click/config.h>

#include <iostream>

#include "mysql.hh"

CLICK_DECLS

SQL::MySQLConnection::MySQLConnection(const std::string& url): mysql_(mysql_init(0))
{
    if (!mysql_)
        throw SQLException("mysql_init has failed.");
    
    std::string db;
    std::string server;
    std::string user;
    std::string pass;
        
    size_t s_pos = url.find("dbname=");
    
    if (s_pos != std::string::npos)
    {
        s_pos += 7;
        size_t e_pos = url.find(" ", s_pos);
        db = url.substr(s_pos, e_pos - s_pos);
    }
    
    s_pos = url.find("host=");
        
    if (s_pos != std::string::npos)
    {
        s_pos += 5;
        size_t e_pos = url.find(" ", s_pos);
        server = url.substr(s_pos, e_pos - s_pos);
    }
    
    s_pos = url.find("user=");
            
    if (s_pos != std::string::npos)
    {
        s_pos += 5;
        size_t e_pos = url.find(" ", s_pos);
        user = url.substr(s_pos, e_pos - s_pos);
    }
    
    s_pos = url.find("pass=");
                
    if (s_pos != std::string::npos)
    {
        s_pos += 5;
        size_t e_pos = url.find(" ", s_pos);
        pass = url.substr(s_pos, e_pos - s_pos);
    }
    
    if (!mysql_real_connect(mysql_, server.c_str(), user.c_str(), pass.c_str(), db.c_str(), 0, 0, 0))
        throw SQLException(mysql_error(mysql_));
}

SQL::MySQLConnection::~MySQLConnection()
{
    close();
}

void SQL::MySQLConnection::close()
{
    mysql_close(mysql_);
}

bool SQL::MySQLConnection::execute_query(const std::string& sql, bool throw_on_error)
{
    if (mysql_query(mysql_, sql.c_str()) != 0)
    {
        if (throw_on_error)
            throw SQLException(mysql_error(mysql_));
        else
            return false;
    }
    return true;
}

ELEMENT_REQUIRES(userlevel lib_mysql)
ELEMENT_PROVIDES(MySQL)

CLICK_ENDDECLS

