#ifndef CLICK_MLFLOWCLS_HH
#define CLICK_MLFLOWCLS_HH

#include <click/element.hh>

#include "flowcache.hh"
#include "appmarks.hh"
#include "mlfeatureextractor.hh"
#include "wekacls.hh"

CLICK_DECLS

class MLFlowCls: public Element, public FlowCache::FlowStateHolder
{
public:
    MLFlowCls();
    ~MLFlowCls();

    const char* class_name() const { return "MLFlowCls"; }
    const char* port_count() const { return PORTS_1_1; }
    const char* processing() const { return AGNOSTIC;  }

    int configure(Vector<String>& conf, ErrorHandler* errh);

    Packet* simple_action(Packet* p);

    void write_header(DataExport& exporter) const;
    void write_flow_state(DataExport& exporter, const BaseFlowState* fs_) const;
    void flow_over(const FlowCache::Flow& flow, BaseFlowState* fs_);

    class FlowState;
private:
    bool try_classify(const FlowCache::Flow& flow, FlowState* fs);
    
    FlowCache* flow_cache_;
    MLFeatureExtractor* ml_feat_extr_;
    
    WekaCls* cls_;
    
    friend class FlowState;
};

class MLFlowCls::FlowState: public BaseFlowState, public AppMark
{
public:
    FlowState() : AppMark(AppMarks::empty_mark) {}
};

CLICK_ENDDECLS

#endif

