#ifndef CLICK_MLFEATUREEXTRACTOR_HH
#define CLICK_MLFEATUREEXTRACTOR_HH

#include <click/element.hh>

#include "flowcache.hh"

CLICK_DECLS

class MLFeatureExtractor: public Element, public FlowCache::FlowStateHolder
{
public:
    MLFeatureExtractor();
    ~MLFeatureExtractor();

    const char* class_name() const { return "MLFeatureExtractor"; }
    const char* port_count() const { return PORTS_1_1; }
    const char* processing() const { return AGNOSTIC;  }

    int configure(Vector<String>& conf, ErrorHandler* errh);

    Packet* simple_action(Packet*);

    void write_header(DataExport& exporter) const;
    void write_flow_state(DataExport& exporter, const BaseFlowState*) const;
    void flow_over(const FlowCache::Flow& flow, BaseFlowState* fs_);
    
    class FlowState;
private:
    size_t series_len;
        
    ErrorHandler* log;
    
    FlowCache* flow_cache;
};

class MLFeatureExtractor::FlowState: public BaseFlowState
{
public:
    inline bool ready() const { return series == 0; }
    inline uint8_t client_data_pkts() const { return data_pkts_clnt; }
    inline uint8_t client_push_pkts() const { return push_pkts_clnt; }
    inline uint8_t server_push_pkts() const { return push_pkts_serv; }
    inline uint16_t client_min_seg_size() const { return min_seg_clnt; }
    inline uint16_t server_avg_seg_size() const { return avg_seg_serv; }
    inline uint16_t client_bytes_in_init_win() const { return ini_win_bytes_clnt; }
    inline uint16_t server_bytes_in_init_win() const { return ini_win_bytes_serv; }
    inline uint8_t client_rtt_samples() const { return rtt_samps_clnt; }
    inline double client_median_bytes() const { return ip_data_byte_med_clnt; }
    inline double server_var_data_bytes() const { return eth_data_byte_var_serv; }
private:
    size_t count;
    
    struct SeriesType { // data required for feature computation
        int dir;
        uint16_t len;
        tcp_seq_t seq;
        tcp_seq_t ack;
        uint16_t data_len;
    };
    SeriesType* series;
    int last_retr[2];
    uint16_t avg_eth_data_byte_serv;
    uint8_t data_pkts_serv; //not a feature, but used
    uint8_t pkts_serv;
    uint8_t pkts_clnt;
    int ini_win_clnt_closed;
    int ini_win_serv_closed;

    uint8_t data_pkts_clnt;
    uint8_t push_pkts_clnt;
    uint8_t push_pkts_serv;
    uint16_t min_seg_clnt; //actually observed.
    uint16_t avg_seg_serv; //would first accumulate up at the intermediate steps.
    uint16_t ini_win_bytes_clnt; //retrans don't count
    uint16_t ini_win_bytes_serv; //retrans don't count
    uint8_t rtt_samps_clnt; //ack = prev seq; packet being acked was not a retrans; plus there's not a retrans between the pkt and ack
    double ip_data_byte_med_clnt;
    double eth_data_byte_var_serv;

    FlowState(Packet* p, size_t series_len);
    ~FlowState();

    void handle_packet(Packet* p, size_t series_len);
    void compute();

    friend class MLFeatureExtractor;
};

CLICK_ENDDECLS

#endif

