/*
 * gtvs.{cc,hh} -- dummy element that serves creating a GTVS flows table
 * 
 * Marco Canini
 *
 * Copyright (c) 2008-09 by University of Genova - DIST - TNT laboratory
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the distribution.
 * * Neither the name of University of Genova nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: gtvs.cc 2209 2009-05-06 18:00:38Z marco $
 */

#include <click/config.h>
#include <click/error.hh>
#include <click/hashmap.hh>
#include <click/straccum.hh>
#include <click/confparse.hh>
#include <clicknet/ip.h>
#include <clicknet/tcp.h>
#include <clicknet/udp.h>
#include <click/packet_anno.hh>
#include <click/handlercall.hh>

#include "gtvs.hh"

CLICK_DECLS

int GTVS::configure(Vector<String>& conf, ErrorHandler* errh)
{
    Element* af_element = 0;
    FlowCache* flow_cache = FlowCache::upstream_instance(this);

    if (cp_va_kparse(conf, this, errh,
            "FLOWCACHE", cpkP, cpElement, &af_element,
            cpEnd) < 0)
        return -1;

    if (af_element && !(flow_cache = (FlowCache*)(af_element->cast("FlowCache"))))
        return errh->error("FLOWCACHE must be a FlowCache element");

    if (!flow_cache)
        return errh->error("Initialization failure!");

    flow_cache->register_flow_state_holder(this);

    return 0;
}

void GTVS::write_header(DataExport& exporter) const
{
    exporter += column<String>("GtProto", 15, true);
    exporter += column<String>("GtApp", 15, true);
    DataExport::Column::EnumType et;
    et.push_back("unverified");
    et.push_back("verified");
    et.push_back("questioned");
    exporter += column("GtState", et, false);
}

void GTVS::write_flow_state(DataExport& exporter, const BaseFlowState*) const
{
    exporter << DataExport::NULL_VALUE;
    exporter << DataExport::NULL_VALUE;
    exporter << "unverified";
}

ELEMENT_REQUIRES(FlowCache)
EXPORT_ELEMENT(GTVS)

#include <click/vector.cc>

CLICK_ENDDECLS

