#ifndef CLICK_FILEEXPORT_HH
#define CLICK_FILEEXPORT_HH

#include <click/string.hh>

#include <iosfwd>

#include "dataexport.hh"

CLICK_DECLS

class FileExport: public DataExport
{
public:
    ~FileExport();

    const char* class_name() const { return "FileExport"; }
    void* cast(const char* n);

    int configure(Vector<String>& conf, ErrorHandler* errh);
    
    String filename() const { return filename_; }
protected:
    void add_column(const Column& col);
    void write(const String& val);
    void write_null();
    void done();
private:
    String filename_;
    std::ostream* os_;
};

CLICK_ENDDECLS
#endif

