package it.unige.dist.tnt.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ConnectionFactory {

    /** String constant for the commonly used MySQL JDBC driver */
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    /** String constant for the JDBC/ODBC bridge driver */
    public static final String DRIVER_JDBC_OBDC = "sun.jdbc.odbc.JdbcOdbcDriver";
    
    /** Protocol prefix for JDBC URLs */
    public static final String PROTOCOL_JDBC = "jdbc:";
    /** Sub-protocol prefix for MySQL connections */
    public static final String SUBPROTOCOL_MYSQL = "mysql:";
    /** Sub-protocol prefix for JDBC/ODBC bridge connections */
    public static final String SUBPROTOCOL_JDBC_ODBC = "odbc:";

    /**
     * Get a new database connection.
     * @param driver the database driver to use, must resolve to a valid Java
     * class on the current classpath.
     * @param url the url for the database, of the form
     * "jdbc:<database_sub_protocol>://&lt;hostname&gt;/&lt;database_name&gt;
     * @param user the database username
     * @param password the database password
     * @return a DatabaseDataSource for interacting with the database
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public static Connection getDatabaseConnection(String driver,
            String url, String user, String password)
        throws SQLException, ClassNotFoundException
    {
        Class.forName(driver);
        return DriverManager.getConnection(url, user, password);
    }    
    
    // ------------------------------------------------------------------------
    // Driver Specific Methods
    
    // -- MySQL ---------------------------------------------------------------
    
    /**
     * Get a new database connection to a MySQL database.
     * @param host the ip address or host name of the database server
     * @param database the name of the particular database to use
     * @param user the database username
     * @param password the database password
     * @return a DatabaseDataSource for interacting with the database
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public static Connection getMySQLConnection(
            String host, String database, String user, String password)
        throws SQLException, ClassNotFoundException
    {
        String url = PROTOCOL_JDBC + SUBPROTOCOL_MYSQL 
                   + "//" + host + "/" + database;
        return getDatabaseConnection(DRIVER_MYSQL,url,user,password);
    }

}
