package it.unige.dist.tnt.gtvs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class Resolver implements Runnable {
	
	private long address;
	
	Logger log = Logger.getLogger(Resolver.class.getName());
	
	public Resolver(long address) {
		this.address = address;
	}

	private static byte[] intToByte(final long i){
		byte[] b = new byte[4];
		b[0] = (byte)  (i >> 24);
		b[1] = (byte) ((i & 0x00ff0000) >> 16);
		b[2] = (byte) ((i & 0x0000ff00) >> 8);
		b[3] = (byte)  (i & 0x000000ff);
		return b;
	}

	public void run() {
		byte[] address = intToByte(this.address);
		
		
		InetAddress addr;
		try {
			addr = InetAddress.getByAddress(address);
			log.info("Resolving host name for " + addr.getHostAddress());
			String name = addr.getCanonicalHostName();
			
			log.info(name);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
	}

}
