package it.unige.dist.tnt.gtvs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class JvmResolver implements Runnable {

	private String address;
	
	Logger log = Logger.getLogger(DnsJavaResolver.class.getName());
	
	public JvmResolver(String address) {
		this.address = address;
	}
	
	public void run() {
		try {
			log.info("Resolving host name for " + address);
			InetAddress addr = InetAddress.getByName(address);
			String name = addr.getCanonicalHostName();
			
			log.info(address + ": " + name);
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}

	}

}
