package it.unige.dist.tnt.gtvs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import org.xbill.DNS.Address;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class DnsJavaResolver implements Runnable {

	private String address;
	private ResolverListener listener;
	
	Logger log = Logger.getLogger(DnsJavaResolver.class.getName());
	
	public DnsJavaResolver(String address, ResolverListener listener) {
		this.address = address;
		this.listener = listener;
	}
	
	public void run() {
		try {
			//log.info("Resolving host name for " + address);
			Lookup l = new Lookup(ReverseMap.fromAddress(address, Address.IPv4), Type.PTR);
			l.run();
			if (l.getResult() == Lookup.SUCCESSFUL) {
				Record[] answers = l.getAnswers();
				if (answers.length == 1) {
					String hostname = answers[0].rdataToString();
					hostname = hostname.substring(0, hostname.length() - 1);
					log.info("Address resolved: " + address + ": " + hostname);
					listener.notifyResolution(address, hostname);
				} else {
					StringBuffer buf = new StringBuffer();
					for (int i = 0; i < answers.length; i++) {
						String hostname = answers[i].rdataToString();
						hostname = hostname.substring(0, hostname.length() - 1);
			                        log.info("Multiple answers: " + address + ": " + hostname);
						if (i > 0)
							buf.append(' ');
						buf.append(hostname);
					}
					listener.notifyResolution(address, buf.toString());
				}
			} else {
                            //log.info("Unresolved address: " + address);
                        }
			
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
	}

}

